/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.security.servlet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.web.PathMappedEndpoints;
import org.springframework.boot.autoconfigure.web.servlet.DispatcherServletPathProvider;
import org.springframework.boot.security.servlet.ApplicationContextRequestMatcher;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.context.WebApplicationContext;

public final class EndpointRequest {
    private static final RequestMatcher EMPTY_MATCHER = request -> false;

    private EndpointRequest() {
    }

    public static EndpointRequestMatcher toAnyEndpoint() {
        return new EndpointRequestMatcher(true);
    }

    public static EndpointRequestMatcher to(Class<?> ... endpoints) {
        return new EndpointRequestMatcher(endpoints, false);
    }

    public static EndpointRequestMatcher to(String ... endpoints) {
        return new EndpointRequestMatcher(endpoints, false);
    }

    public static LinksRequestMatcher toLinks() {
        return new LinksRequestMatcher();
    }

    private static class RequestMatcherFactory {
        private final String servletPath;

        RequestMatcherFactory(String servletPath) {
            this.servletPath = servletPath;
        }

        public RequestMatcher antPath(String ... parts) {
            String pattern = this.servletPath.equals("/") ? "" : this.servletPath;
            for (String part : parts) {
                pattern = pattern + part;
            }
            return new AntPathRequestMatcher(pattern);
        }
    }

    public static final class LinksRequestMatcher
    extends AbstractRequestMatcher {
        @Override
        protected RequestMatcher createDelegate(WebApplicationContext context, RequestMatcherFactory requestMatcherFactory) {
            WebEndpointProperties properties = (WebEndpointProperties)context.getBean(WebEndpointProperties.class);
            if (StringUtils.hasText((String)properties.getBasePath())) {
                return requestMatcherFactory.antPath(properties.getBasePath());
            }
            return EMPTY_MATCHER;
        }
    }

    public static final class EndpointRequestMatcher
    extends AbstractRequestMatcher {
        private final List<Object> includes;
        private final List<Object> excludes;
        private final boolean includeLinks;

        private EndpointRequestMatcher(boolean includeLinks) {
            this(Collections.emptyList(), Collections.emptyList(), includeLinks);
        }

        private EndpointRequestMatcher(Class<?>[] endpoints, boolean includeLinks) {
            this(Arrays.asList((Object[])endpoints), Collections.emptyList(), includeLinks);
        }

        private EndpointRequestMatcher(String[] endpoints, boolean includeLinks) {
            this(Arrays.asList((Object[])endpoints), Collections.emptyList(), includeLinks);
        }

        private EndpointRequestMatcher(List<Object> includes, List<Object> excludes, boolean includeLinks) {
            this.includes = includes;
            this.excludes = excludes;
            this.includeLinks = includeLinks;
        }

        public EndpointRequestMatcher excluding(Class<?> ... endpoints) {
            ArrayList<Object> excludes = new ArrayList<Object>(this.excludes);
            excludes.addAll(Arrays.asList((Object[])endpoints));
            return new EndpointRequestMatcher(this.includes, excludes, this.includeLinks);
        }

        public EndpointRequestMatcher excluding(String ... endpoints) {
            ArrayList<Object> excludes = new ArrayList<Object>(this.excludes);
            excludes.addAll(Arrays.asList((Object[])endpoints));
            return new EndpointRequestMatcher(this.includes, excludes, this.includeLinks);
        }

        public EndpointRequestMatcher excludingLinks() {
            return new EndpointRequestMatcher(this.includes, this.excludes, false);
        }

        @Override
        protected RequestMatcher createDelegate(WebApplicationContext context, RequestMatcherFactory requestMatcherFactory) {
            PathMappedEndpoints pathMappedEndpoints = (PathMappedEndpoints)context.getBean(PathMappedEndpoints.class);
            LinkedHashSet<String> paths = new LinkedHashSet<String>();
            if (this.includes.isEmpty()) {
                paths.addAll(pathMappedEndpoints.getAllPaths());
            }
            this.streamPaths(this.includes, pathMappedEndpoints).forEach(paths::add);
            this.streamPaths(this.excludes, pathMappedEndpoints).forEach(paths::remove);
            List<RequestMatcher> delegateMatchers = this.getDelegateMatchers(requestMatcherFactory, paths);
            if (this.includeLinks && StringUtils.hasText((String)pathMappedEndpoints.getBasePath())) {
                delegateMatchers.add(requestMatcherFactory.antPath(pathMappedEndpoints.getBasePath()));
            }
            return new OrRequestMatcher(delegateMatchers);
        }

        private Stream<String> streamPaths(List<Object> source, PathMappedEndpoints pathMappedEndpoints) {
            return source.stream().filter(Objects::nonNull).map(this::getEndpointId).map(arg_0 -> ((PathMappedEndpoints)pathMappedEndpoints).getPath(arg_0));
        }

        private String getEndpointId(Object source) {
            if (source instanceof String) {
                return (String)source;
            }
            if (source instanceof Class) {
                return this.getEndpointId((Class)source);
            }
            throw new IllegalStateException("Unsupported source " + source);
        }

        private String getEndpointId(Class<?> source) {
            Endpoint annotation = (Endpoint)AnnotationUtils.findAnnotation(source, Endpoint.class);
            Assert.state((annotation != null ? 1 : 0) != 0, () -> "Class " + source + " is not annotated with @Endpoint");
            return annotation.id();
        }

        private List<RequestMatcher> getDelegateMatchers(RequestMatcherFactory requestMatcherFactory, Set<String> paths) {
            return paths.stream().map(path -> requestMatcherFactory.antPath((String)path, "/**")).collect(Collectors.toList());
        }
    }

    private static abstract class AbstractRequestMatcher
    extends ApplicationContextRequestMatcher<WebApplicationContext> {
        private volatile RequestMatcher delegate;

        AbstractRequestMatcher() {
            super(WebApplicationContext.class);
        }

        protected final void initialized(Supplier<WebApplicationContext> context) {
            this.delegate = this.createDelegate(context.get());
        }

        protected final boolean matches(HttpServletRequest request, Supplier<WebApplicationContext> context) {
            return this.delegate.matches(request);
        }

        private RequestMatcher createDelegate(WebApplicationContext context) {
            try {
                RequestMatcherFactory requestMatcherFactory = new RequestMatcherFactory(((DispatcherServletPathProvider)context.getBean(DispatcherServletPathProvider.class)).getServletPath());
                return this.createDelegate(context, requestMatcherFactory);
            }
            catch (NoSuchBeanDefinitionException ex) {
                return EMPTY_MATCHER;
            }
        }

        protected abstract RequestMatcher createDelegate(WebApplicationContext var1, RequestMatcherFactory var2);
    }
}

