/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.trace;

import javax.servlet.Servlet;
import javax.servlet.ServletRegistration;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.trace.TraceEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.trace.TraceRepositoryAutoConfiguration;
import org.springframework.boot.actuate.trace.TraceRepository;
import org.springframework.boot.actuate.trace.WebRequestTraceFilter;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.DispatcherServlet;

@Configuration
@ConditionalOnClass(value={Servlet.class, DispatcherServlet.class, ServletRegistration.class})
@AutoConfigureAfter(value={TraceRepositoryAutoConfiguration.class})
@ConditionalOnProperty(prefix="management.trace.filter", name={"enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={TraceEndpointProperties.class})
public class TraceWebFilterAutoConfiguration {
    private final TraceRepository traceRepository;
    private final TraceEndpointProperties endpointProperties;
    private final ErrorAttributes errorAttributes;

    public TraceWebFilterAutoConfiguration(TraceRepository traceRepository, TraceEndpointProperties endpointProperties, ObjectProvider<ErrorAttributes> errorAttributes) {
        this.traceRepository = traceRepository;
        this.endpointProperties = endpointProperties;
        this.errorAttributes = (ErrorAttributes)errorAttributes.getIfAvailable();
    }

    @Bean
    @ConditionalOnMissingBean
    public WebRequestTraceFilter webRequestLoggingFilter() {
        WebRequestTraceFilter filter = new WebRequestTraceFilter(this.traceRepository, this.endpointProperties.getInclude());
        if (this.errorAttributes != null) {
            filter.setErrorAttributes(this.errorAttributes);
        }
        return filter;
    }
}

