/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.export.datadog;

import io.micrometer.core.instrument.Clock;
import io.micrometer.datadog.DatadogConfig;
import io.micrometer.datadog.DatadogMeterRegistry;
import org.springframework.boot.actuate.autoconfigure.metrics.export.MetricsExporter;
import org.springframework.boot.actuate.autoconfigure.metrics.export.datadog.DatadogProperties;
import org.springframework.boot.actuate.autoconfigure.metrics.export.datadog.DatadogPropertiesConfigAdapter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={DatadogMeterRegistry.class})
@ConditionalOnProperty(value={"spring.metrics.export.datadog.api-key"})
@EnableConfigurationProperties(value={DatadogProperties.class})
public class DatadogExportConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public DatadogConfig datadogConfig(DatadogProperties datadogProperties) {
        return new DatadogPropertiesConfigAdapter(datadogProperties);
    }

    @Bean
    @ConditionalOnProperty(value={"spring.metrics.export.datadog.enabled"}, matchIfMissing=true)
    public MetricsExporter datadogExporter(DatadogConfig datadogConfig, Clock clock) {
        return () -> new DatadogMeterRegistry(datadogConfig, clock);
    }

    @Bean
    @ConditionalOnMissingBean
    public Clock micrometerClock() {
        return Clock.SYSTEM;
    }
}

