/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint.condition;

import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.EndpointExtension;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

class OnEnabledEndpointCondition
extends SpringBootCondition {
    private static final String ENABLED_BY_DEFAULT_KEY = "management.endpoints.enabled-by-default";

    OnEnabledEndpointCondition() {
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        AnnotationAttributes attributes = this.getEndpointAttributes(context, metadata);
        String id = attributes.getString("id");
        String key = "management.endpoint." + id + ".enabled";
        Boolean userDefinedEnabled = (Boolean)context.getEnvironment().getProperty(key, Boolean.class);
        if (userDefinedEnabled != null) {
            return new ConditionOutcome(userDefinedEnabled.booleanValue(), ConditionMessage.forCondition(ConditionalOnEnabledEndpoint.class, (Object[])new Object[0]).because("found property " + key + " with value " + userDefinedEnabled));
        }
        Boolean userDefinedDefault = (Boolean)context.getEnvironment().getProperty(ENABLED_BY_DEFAULT_KEY, Boolean.class);
        if (userDefinedDefault != null) {
            return new ConditionOutcome(userDefinedDefault.booleanValue(), ConditionMessage.forCondition(ConditionalOnEnabledEndpoint.class, (Object[])new Object[0]).because("no property " + key + " found so using user defined default from " + ENABLED_BY_DEFAULT_KEY));
        }
        boolean endpointDefault = attributes.getBoolean("enableByDefault");
        return new ConditionOutcome(endpointDefault, ConditionMessage.forCondition(ConditionalOnEnabledEndpoint.class, (Object[])new Object[0]).because("no property " + key + " found so using endpoint default"));
    }

    private AnnotationAttributes getEndpointAttributes(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Assert.state((metadata instanceof MethodMetadata && metadata.isAnnotated(Bean.class.getName()) ? 1 : 0) != 0, (String)"OnEnabledEndpointCondition may only be used on @Bean methods");
        return this.getEndpointAttributes(context, (MethodMetadata)metadata);
    }

    private AnnotationAttributes getEndpointAttributes(ConditionContext context, MethodMetadata metadata) {
        try {
            Class returnType = ClassUtils.forName((String)metadata.getReturnTypeName(), (ClassLoader)context.getClassLoader());
            return this.getEndpointAttributes(returnType);
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Failed to extract endpoint id for " + metadata.getDeclaringClassName() + "." + metadata.getMethodName(), ex);
        }
    }

    protected AnnotationAttributes getEndpointAttributes(Class<?> type) {
        AnnotationAttributes attributes = AnnotatedElementUtils.findMergedAnnotationAttributes(type, Endpoint.class, (boolean)true, (boolean)true);
        if (attributes == null && (attributes = AnnotatedElementUtils.findMergedAnnotationAttributes(type, EndpointExtension.class, (boolean)false, (boolean)true)) != null) {
            return this.getEndpointAttributes(attributes.getClass("endpoint"));
        }
        Assert.state((attributes != null ? 1 : 0) != 0, (String)"OnEnabledEndpointCondition may only be used on @Bean methods that return an @Endpoint or and @EndpointExtension");
        return attributes;
    }
}

