/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.cloudfoundry.reactive;

import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.CloudFoundryAuthorizationException;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.Token;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.reactive.ReactiveCloudFoundrySecurityService;
import org.springframework.util.Base64Utils;
import reactor.core.publisher.Mono;

class ReactiveTokenValidator {
    private final ReactiveCloudFoundrySecurityService securityService;
    private Map<String, String> cachedTokenKeys = new ConcurrentHashMap<String, String>();

    ReactiveTokenValidator(ReactiveCloudFoundrySecurityService securityService) {
        this.securityService = securityService;
    }

    public Mono<Void> validate(Token token) {
        return this.validateAlgorithm(token).then(this.validateKeyIdAndSignature(token)).then(this.validateExpiry(token)).then(this.validateIssuer(token)).then(this.validateAudience(token));
    }

    private Mono<Void> validateAlgorithm(Token token) {
        String algorithm = token.getSignatureAlgorithm();
        if (algorithm == null) {
            return Mono.error((Throwable)new CloudFoundryAuthorizationException(CloudFoundryAuthorizationException.Reason.INVALID_SIGNATURE, "Signing algorithm cannot be null"));
        }
        if (!algorithm.equals("RS256")) {
            return Mono.error((Throwable)new CloudFoundryAuthorizationException(CloudFoundryAuthorizationException.Reason.UNSUPPORTED_TOKEN_SIGNING_ALGORITHM, "Signing algorithm " + algorithm + " not supported"));
        }
        return Mono.empty();
    }

    private Mono<Void> validateKeyIdAndSignature(Token token) {
        return this.getTokenKey(token).filter(tokenKey -> this.hasValidSignature(token, (String)tokenKey)).switchIfEmpty(Mono.error((Throwable)new CloudFoundryAuthorizationException(CloudFoundryAuthorizationException.Reason.INVALID_SIGNATURE, "RSA Signature did not match content"))).then();
    }

    private Mono<String> getTokenKey(Token token) {
        String keyId = token.getKeyId();
        String cached = this.cachedTokenKeys.get(keyId);
        if (cached != null) {
            return Mono.just((Object)cached);
        }
        return this.securityService.fetchTokenKeys().doOnSuccess(this::cacheTokenKeys).filter(tokenKeys -> tokenKeys.containsKey(keyId)).map(tokenKeys -> (String)tokenKeys.get(keyId)).switchIfEmpty(Mono.error((Throwable)new CloudFoundryAuthorizationException(CloudFoundryAuthorizationException.Reason.INVALID_KEY_ID, "Key Id present in token header does not match")));
    }

    private void cacheTokenKeys(Map<String, String> tokenKeys) {
        this.cachedTokenKeys.clear();
        this.cachedTokenKeys.putAll(tokenKeys);
    }

    private boolean hasValidSignature(Token token, String key) {
        try {
            PublicKey publicKey = this.getPublicKey(key);
            Signature signature = Signature.getInstance("SHA256withRSA");
            signature.initVerify(publicKey);
            signature.update(token.getContent());
            return signature.verify(token.getSignature());
        }
        catch (GeneralSecurityException ex) {
            return false;
        }
    }

    private PublicKey getPublicKey(String key) throws NoSuchAlgorithmException, InvalidKeySpecException {
        key = key.replace("-----BEGIN PUBLIC KEY-----\n", "");
        key = key.replace("-----END PUBLIC KEY-----", "");
        key = key.trim().replace("\n", "");
        byte[] bytes = Base64Utils.decodeFromString((String)key);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(bytes);
        return KeyFactory.getInstance("RSA").generatePublic(keySpec);
    }

    private Mono<Void> validateExpiry(Token token) {
        long currentTime = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
        if (currentTime > token.getExpiry()) {
            return Mono.error((Throwable)new CloudFoundryAuthorizationException(CloudFoundryAuthorizationException.Reason.TOKEN_EXPIRED, "Token expired"));
        }
        return Mono.empty();
    }

    private Mono<Void> validateIssuer(Token token) {
        return this.securityService.getUaaUrl().map(uaaUrl -> String.format("%s/oauth/token", uaaUrl)).filter(issuerUri -> issuerUri.equals(token.getIssuer())).switchIfEmpty(Mono.error((Throwable)new CloudFoundryAuthorizationException(CloudFoundryAuthorizationException.Reason.INVALID_ISSUER, "Token issuer does not match"))).then();
    }

    private Mono<Void> validateAudience(Token token) {
        if (!token.getScope().contains("actuator.read")) {
            return Mono.error((Throwable)new CloudFoundryAuthorizationException(CloudFoundryAuthorizationException.Reason.INVALID_AUDIENCE, "Token does not have audience actuator"));
        }
        return Mono.empty();
    }
}

