/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.experimental.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.util.FileUtils;
import org.springframework.boot.experimental.maven.ThinJarMojo;

@Mojo(name="resolve", defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true, threadSafe=true, requiresDependencyResolution=ResolutionScope.NONE, requiresDependencyCollection=ResolutionScope.NONE)
public class ResolveMojo
extends ThinJarMojo {
    @Parameter(defaultValue="${project.build.directory}/thin/root", required=true, property="thin.outputDirectory")
    private File outputDirectory;
    @Parameter
    private List<Dependency> deployables;
    @Parameter(property="thin.includeSelf")
    private boolean includeSelf = true;
    @Parameter(property="thin.unpack")
    private boolean unpack = false;
    @Component
    protected ArchiverManager archiverManager;
    @Component
    private MavenProject mavenProject;
    @Component
    private MavenSession mavenSession;
    @Component
    private BuildPluginManager pluginManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.project.getPackaging().equals("pom")) {
            this.getLog().debug((CharSequence)"Thin resolve goal could not be applied to pom project.");
            return;
        }
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution");
            return;
        }
        this.outputDirectory.mkdirs();
        ArrayList<File> deployables = new ArrayList<File>();
        File file = this.project.getArtifact().getFile();
        if (file != null && this.includeSelf && !this.unpack) {
            deployables.add(file);
        }
        if (this.deployables != null) {
            for (Dependency dependency : this.deployables) {
                File resolved;
                if (dependency == null || (resolved = this.resolveFile(dependency)) == null) continue;
                deployables.add(resolved);
            }
        }
        if (deployables.isEmpty()) {
            throw new MojoExecutionException("No deployables found. If your only deployable is the current project jar, you need to run 'mvn package' at the same time.");
        }
        File thinJar = this.downloadThinJar(this.outputDirectory);
        for (File deployable : deployables) {
            this.getLog().info((CharSequence)("Deploying: " + deployable));
            try {
                this.getLog().info((CharSequence)("Copying: " + deployable.getName() + " to " + this.outputDirectory));
                FileUtils.copyFile((File)deployable, (File)new File(this.outputDirectory, deployable.getName()));
                this.runWithForkedJvm(thinJar, this.outputDirectory, "--thin.archive=" + deployable.getAbsolutePath());
            }
            catch (Exception e) {
                throw new MojoExecutionException("Cannot locate deployable " + deployable, e);
            }
        }
        if (this.includeSelf && this.unpack) {
            try {
                this.runWithForkedJvm(file, this.outputDirectory, new String[0]);
                UnArchiver unArchiver = this.archiverManager.getUnArchiver(file);
                unArchiver.setSourceFile(file);
                unArchiver.setDestDirectory(this.outputDirectory);
                unArchiver.setOverwrite(true);
                unArchiver.setUseJvmChmod(true);
                unArchiver.extract();
            }
            catch (NoSuchArchiverException noSuchArchiverException) {
                throw new MojoExecutionException("Cannot unpack artifact " + file, (Exception)((Object)noSuchArchiverException));
            }
        }
        if (!new File(this.outputDirectory, "repository").exists() || new File(this.outputDirectory, "repository").listFiles().length == 0) {
            throw new MojoExecutionException("No dependencies resolved. Is the thin layout applied to the Spring Boot plugin as a dependency?");
        }
        this.getLog().info((CharSequence)("All deployables and dependencies ready in: " + this.outputDirectory));
    }
}

