/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.eclipse.sisu.wire;

import hidden.com.google.inject.Binding;
import hidden.com.google.inject.Key;
import hidden.com.google.inject.TypeLiteral;
import hidden.com.google.inject.spi.DefaultBindingTargetVisitor;
import hidden.com.google.inject.spi.InjectionPoint;
import hidden.com.google.inject.spi.LinkedKeyBinding;
import hidden.com.google.inject.spi.UntargettedBinding;
import hidden.org.eclipse.sisu.inject.Logs;
import hidden.org.eclipse.sisu.inject.TypeArguments;

final class DependencyVerifier
extends DefaultBindingTargetVisitor<Object, Boolean> {
    DependencyVerifier() {
    }

    @Override
    public Boolean visit(UntargettedBinding<?> binding) {
        return DependencyVerifier.verifyImplementation(binding.getKey().getTypeLiteral());
    }

    @Override
    public Boolean visit(LinkedKeyBinding<?> binding) {
        Key<?> linkedKey = binding.getLinkedKey();
        if (linkedKey.getAnnotationType() == null) {
            return DependencyVerifier.verifyImplementation(linkedKey.getTypeLiteral());
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitOther(Binding<?> binding) {
        return Boolean.TRUE;
    }

    private static Boolean verifyImplementation(TypeLiteral<?> type) {
        if (TypeArguments.isConcrete(type) && !type.toString().startsWith("java")) {
            try {
                InjectionPoint.forInstanceMethodsAndFields(type);
                InjectionPoint.forConstructorOf(type);
            }
            catch (RuntimeException e) {
                Logs.trace("Potential problem: {}", type, e);
                return Boolean.FALSE;
            }
            catch (LinkageError e) {
                Logs.trace("Potential problem: {}", type, e);
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }
}

