/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.eclipse.sisu.osgi;

import hidden.com.google.inject.Binder;
import hidden.com.google.inject.Binding;
import hidden.com.google.inject.Key;
import hidden.com.google.inject.Provider;
import hidden.com.google.inject.name.Names;
import hidden.com.google.inject.spi.BindingScopingVisitor;
import hidden.com.google.inject.spi.BindingTargetVisitor;
import hidden.com.google.inject.spi.ElementVisitor;
import hidden.org.eclipse.sisu.inject.BindingSubscriber;
import java.lang.annotation.Annotation;
import javax.inject.Singleton;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

final class ServiceBinding<T>
implements Binding<T>,
Provider<T> {
    private final Key<T> key;
    private final T instance;
    private final int rank;

    ServiceBinding(BundleContext context, String clazzName, int maxRank, ServiceReference<T> reference) throws ClassNotFoundException {
        int serviceRanking;
        Class clazz = reference.getBundle().loadClass(clazzName);
        Object name = reference.getProperty("name");
        this.key = name instanceof String && ((String)name).length() > 0 ? Key.get(clazz, (Annotation)Names.named((String)name)) : Key.get(clazz);
        this.instance = context.getService(reference);
        this.rank = maxRank > Integer.MIN_VALUE ? ((serviceRanking = ServiceBinding.getServiceRanking(reference)) < maxRank ? serviceRanking : maxRank) : Integer.MIN_VALUE;
    }

    @Override
    public Key<T> getKey() {
        return this.key;
    }

    @Override
    public Provider<T> getProvider() {
        return this;
    }

    @Override
    public T get() {
        return this.instance;
    }

    @Override
    public Object getSource() {
        return "OSGi service registry";
    }

    @Override
    public void applyTo(Binder binder) {
    }

    public <V> V acceptVisitor(ElementVisitor<V> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <V> V acceptTargetVisitor(BindingTargetVisitor<? super T, V> visitor) {
        return null;
    }

    @Override
    public <V> V acceptScopingVisitor(BindingScopingVisitor<V> visitor) {
        return visitor.visitScopeAnnotation(Singleton.class);
    }

    boolean isCompatibleWith(BindingSubscriber<T> subscriber) {
        return this.key.getTypeLiteral().getRawType().equals(subscriber.type().getRawType());
    }

    int rank() {
        return this.rank;
    }

    private static int getServiceRanking(ServiceReference<?> reference) {
        Object ranking = reference.getProperty("service.ranking");
        return ranking instanceof Integer ? (Integer)ranking : 0;
    }
}

