/*
 * Decompiled with CFR 0.152.
 */
package hidden.com.google.inject.internal;

import hidden.com.google.common.collect.Lists;
import hidden.com.google.inject.Key;
import hidden.com.google.inject.MembersInjector;
import hidden.com.google.inject.Provider;
import hidden.com.google.inject.TypeLiteral;
import hidden.com.google.inject.internal.Errors;
import hidden.com.google.inject.internal.InjectorImpl;
import hidden.com.google.inject.internal.LookupProcessor;
import hidden.com.google.inject.internal.Lookups;
import hidden.com.google.inject.spi.Element;
import hidden.com.google.inject.spi.MembersInjectorLookup;
import hidden.com.google.inject.spi.ProviderLookup;
import java.util.List;

final class DeferredLookups
implements Lookups {
    private final InjectorImpl injector;
    private final List<Element> lookups = Lists.newArrayList();

    DeferredLookups(InjectorImpl injector) {
        this.injector = injector;
    }

    void initialize(Errors errors) {
        this.injector.lookups = this.injector;
        new LookupProcessor(errors).process(this.injector, this.lookups);
    }

    @Override
    public <T> Provider<T> getProvider(Key<T> key) {
        ProviderLookup<T> lookup = new ProviderLookup<T>(key, key);
        this.lookups.add(lookup);
        return lookup.getProvider();
    }

    @Override
    public <T> MembersInjector<T> getMembersInjector(TypeLiteral<T> type) {
        MembersInjectorLookup<T> lookup = new MembersInjectorLookup<T>(type, type);
        this.lookups.add(lookup);
        return lookup.getMembersInjector();
    }
}

