/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.thin;

import java.util.logging.Logger;
import org.springframework.boot.loader.thin.Level;

class LogUtils {
    public static final String ROOT_LOGGER_NAME = "";

    LogUtils() {
    }

    public static void setLogLevel(Level level) {
        LogUtils.setLogLevel(ROOT_LOGGER_NAME, level);
    }

    private static void setLogLevel(String loggerName, Level level) {
        Logger logger = LogUtils.getLogger(loggerName);
        if (logger != null) {
            logger.setLevel(LogUtils.convert(level));
        }
    }

    private static java.util.logging.Level convert(Level level) {
        switch (level) {
            case OFF: {
                return java.util.logging.Level.OFF;
            }
            case ERROR: {
                return java.util.logging.Level.SEVERE;
            }
            case WARN: {
                return java.util.logging.Level.WARNING;
            }
            case DEBUG: {
                return java.util.logging.Level.FINE;
            }
            case TRACE: {
                return java.util.logging.Level.FINEST;
            }
        }
        return java.util.logging.Level.INFO;
    }

    private static Logger getLogger(String name) {
        return Logger.getLogger(name);
    }
}

