/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.eclipse.sisu.plexus;

import hidden.com.google.inject.Binder;
import hidden.com.google.inject.Module;
import hidden.org.eclipse.sisu.plexus.PlexusAnnotatedMetadata;
import hidden.org.eclipse.sisu.plexus.PlexusBeanMetadata;
import hidden.org.eclipse.sisu.plexus.PlexusBeanModule;
import hidden.org.eclipse.sisu.plexus.PlexusBeanSource;
import hidden.org.eclipse.sisu.plexus.PlexusTypeBinder;
import hidden.org.eclipse.sisu.plexus.PlexusTypeVisitor;
import hidden.org.eclipse.sisu.space.BeanScanning;
import hidden.org.eclipse.sisu.space.ClassSpace;
import hidden.org.eclipse.sisu.space.SpaceModule;
import hidden.org.eclipse.sisu.space.SpaceVisitor;
import java.util.Map;
import org.codehaus.plexus.component.annotations.Component;

public final class PlexusAnnotatedBeanModule
implements PlexusBeanModule {
    private static final SpaceModule.Strategy PLEXUS_STRATEGY = new SpaceModule.Strategy(){

        @Override
        public SpaceVisitor visitor(Binder binder) {
            return new PlexusTypeVisitor(new PlexusTypeBinder(binder));
        }
    };
    private Module spaceModule;
    private final PlexusBeanSource beanSource;

    public PlexusAnnotatedBeanModule(ClassSpace space, Map<?, ?> variables) {
        this(space, variables, BeanScanning.ON);
    }

    public PlexusAnnotatedBeanModule(ClassSpace space, Map<?, ?> variables, BeanScanning scanning) {
        this.spaceModule = space != null && scanning != BeanScanning.OFF ? new SpaceModule(space, scanning).with(PLEXUS_STRATEGY) : null;
        this.beanSource = new PlexusAnnotatedBeanSource(variables);
    }

    public PlexusBeanModule with(SpaceModule.Strategy _strategy) {
        if (this.spaceModule instanceof SpaceModule) {
            this.spaceModule = ((SpaceModule)this.spaceModule).with(_strategy);
        }
        return this;
    }

    @Override
    public PlexusBeanSource configure(Binder binder) {
        if (this.spaceModule != null) {
            this.spaceModule.configure(binder);
        }
        return this.beanSource;
    }

    private static final class PlexusAnnotatedBeanSource
    implements PlexusBeanSource {
        private final PlexusBeanMetadata metadata;

        PlexusAnnotatedBeanSource(Map<?, ?> variables) {
            this.metadata = new PlexusAnnotatedMetadata(variables);
        }

        @Override
        public PlexusBeanMetadata getBeanMetadata(Class<?> implementation) {
            return implementation.isAnnotationPresent(Component.class) ? this.metadata : null;
        }
    }
}

