/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.eclipse.aether.internal.impl;

import hidden.org.eclipse.aether.RepositoryEvent;
import hidden.org.eclipse.aether.RepositoryListener;
import hidden.org.eclipse.aether.impl.RepositoryEventDispatcher;
import hidden.org.eclipse.aether.spi.locator.Service;
import hidden.org.eclipse.aether.spi.locator.ServiceLocator;
import hidden.org.eclipse.aether.spi.log.Logger;
import hidden.org.eclipse.aether.spi.log.LoggerFactory;
import hidden.org.eclipse.aether.spi.log.NullLoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class DefaultRepositoryEventDispatcher
implements RepositoryEventDispatcher,
Service {
    private Logger logger = NullLoggerFactory.LOGGER;
    private Collection<RepositoryListener> listeners = new ArrayList<RepositoryListener>();

    public DefaultRepositoryEventDispatcher() {
    }

    @Inject
    DefaultRepositoryEventDispatcher(Set<RepositoryListener> listeners, LoggerFactory loggerFactory) {
        this.setRepositoryListeners(listeners);
        this.setLoggerFactory(loggerFactory);
    }

    public DefaultRepositoryEventDispatcher setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger(loggerFactory, this.getClass());
        return this;
    }

    public DefaultRepositoryEventDispatcher addRepositoryListener(RepositoryListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("repository listener has not been specified");
        }
        this.listeners.add(listener);
        return this;
    }

    public DefaultRepositoryEventDispatcher setRepositoryListeners(Collection<RepositoryListener> listeners) {
        this.listeners = listeners == null ? new ArrayList<RepositoryListener>() : listeners;
        return this;
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setLoggerFactory(locator.getService(LoggerFactory.class));
        this.setRepositoryListeners(locator.getServices(RepositoryListener.class));
    }

    @Override
    public void dispatch(RepositoryEvent event) {
        RepositoryListener listener;
        if (!this.listeners.isEmpty()) {
            for (RepositoryListener listener2 : this.listeners) {
                this.dispatch(event, listener2);
            }
        }
        if ((listener = event.getSession().getRepositoryListener()) != null) {
            this.dispatch(event, listener);
        }
    }

    private void dispatch(RepositoryEvent event, RepositoryListener listener) {
        try {
            switch (event.getType()) {
                case ARTIFACT_DEPLOYED: {
                    listener.artifactDeployed(event);
                    break;
                }
                case ARTIFACT_DEPLOYING: {
                    listener.artifactDeploying(event);
                    break;
                }
                case ARTIFACT_DESCRIPTOR_INVALID: {
                    listener.artifactDescriptorInvalid(event);
                    break;
                }
                case ARTIFACT_DESCRIPTOR_MISSING: {
                    listener.artifactDescriptorMissing(event);
                    break;
                }
                case ARTIFACT_DOWNLOADED: {
                    listener.artifactDownloaded(event);
                    break;
                }
                case ARTIFACT_DOWNLOADING: {
                    listener.artifactDownloading(event);
                    break;
                }
                case ARTIFACT_INSTALLED: {
                    listener.artifactInstalled(event);
                    break;
                }
                case ARTIFACT_INSTALLING: {
                    listener.artifactInstalling(event);
                    break;
                }
                case ARTIFACT_RESOLVED: {
                    listener.artifactResolved(event);
                    break;
                }
                case ARTIFACT_RESOLVING: {
                    listener.artifactResolving(event);
                    break;
                }
                case METADATA_DEPLOYED: {
                    listener.metadataDeployed(event);
                    break;
                }
                case METADATA_DEPLOYING: {
                    listener.metadataDeploying(event);
                    break;
                }
                case METADATA_DOWNLOADED: {
                    listener.metadataDownloaded(event);
                    break;
                }
                case METADATA_DOWNLOADING: {
                    listener.metadataDownloading(event);
                    break;
                }
                case METADATA_INSTALLED: {
                    listener.metadataInstalled(event);
                    break;
                }
                case METADATA_INSTALLING: {
                    listener.metadataInstalling(event);
                    break;
                }
                case METADATA_INVALID: {
                    listener.metadataInvalid(event);
                    break;
                }
                case METADATA_RESOLVED: {
                    listener.metadataResolved(event);
                    break;
                }
                case METADATA_RESOLVING: {
                    listener.metadataResolving(event);
                    break;
                }
                default: {
                    throw new IllegalStateException("unknown repository event type " + (Object)((Object)event.getType()));
                }
            }
        }
        catch (Exception e) {
            this.logError(e, listener);
        }
        catch (LinkageError e) {
            this.logError(e, listener);
        }
    }

    private void logError(Throwable e, Object listener) {
        String msg = "Failed to dispatch repository event to " + listener.getClass().getCanonicalName() + ": " + e.getMessage();
        if (this.logger.isDebugEnabled()) {
            this.logger.warn(msg, e);
        } else {
            this.logger.warn(msg);
        }
    }
}

