/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.maven.repository.legacy.resolver.transform;

import hidden.org.apache.maven.artifact.Artifact;
import hidden.org.apache.maven.artifact.repository.ArtifactRepository;
import hidden.org.apache.maven.artifact.repository.DefaultRepositoryRequest;
import hidden.org.apache.maven.artifact.repository.RepositoryRequest;
import hidden.org.apache.maven.artifact.repository.metadata.AbstractRepositoryMetadata;
import hidden.org.apache.maven.artifact.repository.metadata.ArtifactRepositoryMetadata;
import hidden.org.apache.maven.artifact.repository.metadata.Metadata;
import hidden.org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import hidden.org.apache.maven.artifact.repository.metadata.RepositoryMetadataResolutionException;
import hidden.org.apache.maven.artifact.repository.metadata.SnapshotArtifactRepositoryMetadata;
import hidden.org.apache.maven.artifact.repository.metadata.Versioning;
import hidden.org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import hidden.org.apache.maven.artifact.resolver.ArtifactResolutionException;
import hidden.org.apache.maven.repository.legacy.WagonManager;
import hidden.org.apache.maven.repository.legacy.resolver.transform.ArtifactTransformation;
import java.util.List;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;

public abstract class AbstractVersionTransformation
extends AbstractLogEnabled
implements ArtifactTransformation {
    @Requirement
    protected RepositoryMetadataManager repositoryMetadataManager;
    @Requirement
    protected WagonManager wagonManager;

    @Override
    public void transformForResolve(Artifact artifact, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository) throws ArtifactResolutionException, ArtifactNotFoundException {
        DefaultRepositoryRequest request = new DefaultRepositoryRequest();
        request.setLocalRepository(localRepository);
        request.setRemoteRepositories(remoteRepositories);
        this.transformForResolve(artifact, request);
    }

    protected String resolveVersion(Artifact artifact, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) throws RepositoryMetadataResolutionException {
        DefaultRepositoryRequest request = new DefaultRepositoryRequest();
        request.setLocalRepository(localRepository);
        request.setRemoteRepositories(remoteRepositories);
        return this.resolveVersion(artifact, request);
    }

    protected String resolveVersion(Artifact artifact, RepositoryRequest request) throws RepositoryMetadataResolutionException {
        AbstractRepositoryMetadata metadata = !artifact.isSnapshot() || "LATEST".equals(artifact.getBaseVersion()) ? new ArtifactRepositoryMetadata(artifact) : new SnapshotArtifactRepositoryMetadata(artifact);
        this.repositoryMetadataManager.resolve(metadata, request);
        artifact.addMetadata(metadata);
        Metadata repoMetadata = metadata.getMetadata();
        String version = null;
        if (repoMetadata != null && repoMetadata.getVersioning() != null) {
            version = this.constructVersion(repoMetadata.getVersioning(), artifact.getBaseVersion());
        }
        if (version == null) {
            version = artifact.getBaseVersion();
        }
        if (this.getLogger().isDebugEnabled()) {
            if (!version.equals(artifact.getBaseVersion())) {
                String message = artifact.getArtifactId() + ": resolved to version " + version;
                message = artifact.getRepository() != null ? message + " from repository " + artifact.getRepository().getId() : message + " from local repository";
                this.getLogger().debug(message);
            } else {
                this.getLogger().debug(artifact.getArtifactId() + ": using locally installed snapshot");
            }
        }
        return version;
    }

    protected abstract String constructVersion(Versioning var1, String var2);
}

