/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.maven.repository.internal;

import hidden.org.apache.maven.model.DistributionManagement;
import hidden.org.apache.maven.model.Model;
import hidden.org.apache.maven.model.Relocation;
import hidden.org.apache.maven.model.building.DefaultModelBuilderFactory;
import hidden.org.apache.maven.model.building.DefaultModelBuildingRequest;
import hidden.org.apache.maven.model.building.FileModelSource;
import hidden.org.apache.maven.model.building.ModelBuilder;
import hidden.org.apache.maven.model.building.ModelBuildingException;
import hidden.org.apache.maven.model.building.ModelProblem;
import hidden.org.apache.maven.model.resolution.UnresolvableModelException;
import hidden.org.apache.maven.repository.internal.ArtifactDescriptorReaderDelegate;
import hidden.org.apache.maven.repository.internal.ArtifactDescriptorUtils;
import hidden.org.apache.maven.repository.internal.DefaultModelCache;
import hidden.org.apache.maven.repository.internal.DefaultModelResolver;
import hidden.org.apache.maven.repository.internal.MavenWorkspaceReader;
import hidden.org.apache.maven.repository.internal.RelocatedArtifact;
import hidden.org.eclipse.aether.RepositoryEvent;
import hidden.org.eclipse.aether.RepositoryException;
import hidden.org.eclipse.aether.RepositorySystemSession;
import hidden.org.eclipse.aether.RequestTrace;
import hidden.org.eclipse.aether.artifact.Artifact;
import hidden.org.eclipse.aether.impl.ArtifactDescriptorReader;
import hidden.org.eclipse.aether.impl.ArtifactResolver;
import hidden.org.eclipse.aether.impl.RemoteRepositoryManager;
import hidden.org.eclipse.aether.impl.RepositoryEventDispatcher;
import hidden.org.eclipse.aether.impl.VersionRangeResolver;
import hidden.org.eclipse.aether.impl.VersionResolver;
import hidden.org.eclipse.aether.repository.WorkspaceReader;
import hidden.org.eclipse.aether.repository.WorkspaceRepository;
import hidden.org.eclipse.aether.resolution.ArtifactDescriptorException;
import hidden.org.eclipse.aether.resolution.ArtifactDescriptorPolicy;
import hidden.org.eclipse.aether.resolution.ArtifactDescriptorPolicyRequest;
import hidden.org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import hidden.org.eclipse.aether.resolution.ArtifactDescriptorResult;
import hidden.org.eclipse.aether.resolution.ArtifactRequest;
import hidden.org.eclipse.aether.resolution.ArtifactResolutionException;
import hidden.org.eclipse.aether.resolution.ArtifactResult;
import hidden.org.eclipse.aether.resolution.VersionRequest;
import hidden.org.eclipse.aether.resolution.VersionResolutionException;
import hidden.org.eclipse.aether.resolution.VersionResult;
import hidden.org.eclipse.aether.spi.locator.Service;
import hidden.org.eclipse.aether.spi.locator.ServiceLocator;
import hidden.org.eclipse.aether.spi.log.Logger;
import hidden.org.eclipse.aether.spi.log.LoggerFactory;
import hidden.org.eclipse.aether.spi.log.NullLoggerFactory;
import hidden.org.eclipse.aether.transfer.ArtifactNotFoundException;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.Validate;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

@Named
@Component(role=ArtifactDescriptorReader.class)
public class DefaultArtifactDescriptorReader
implements ArtifactDescriptorReader,
Service {
    @Requirement(role=LoggerFactory.class)
    private Logger logger = NullLoggerFactory.LOGGER;
    @Requirement
    private RemoteRepositoryManager remoteRepositoryManager;
    @Requirement
    private VersionResolver versionResolver;
    @Requirement
    private VersionRangeResolver versionRangeResolver;
    @Requirement
    private ArtifactResolver artifactResolver;
    @Requirement
    private RepositoryEventDispatcher repositoryEventDispatcher;
    @Requirement
    private ModelBuilder modelBuilder;

    public DefaultArtifactDescriptorReader() {
    }

    @Inject
    DefaultArtifactDescriptorReader(RemoteRepositoryManager remoteRepositoryManager, VersionResolver versionResolver, VersionRangeResolver versionRangeResolver, ArtifactResolver artifactResolver, ModelBuilder modelBuilder, RepositoryEventDispatcher repositoryEventDispatcher, LoggerFactory loggerFactory) {
        this.setRemoteRepositoryManager(remoteRepositoryManager);
        this.setVersionResolver(versionResolver);
        this.setArtifactResolver(artifactResolver);
        this.setModelBuilder(modelBuilder);
        this.setLoggerFactory(loggerFactory);
        this.setRepositoryEventDispatcher(repositoryEventDispatcher);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setRemoteRepositoryManager(locator.getService(RemoteRepositoryManager.class));
        this.setVersionResolver(locator.getService(VersionResolver.class));
        this.setVersionRangeResolver(locator.getService(VersionRangeResolver.class));
        this.setArtifactResolver(locator.getService(ArtifactResolver.class));
        this.modelBuilder = locator.getService(ModelBuilder.class);
        if (this.modelBuilder == null) {
            this.setModelBuilder(new DefaultModelBuilderFactory().newInstance());
        }
        this.setRepositoryEventDispatcher(locator.getService(RepositoryEventDispatcher.class));
        this.setLoggerFactory(locator.getService(LoggerFactory.class));
    }

    public DefaultArtifactDescriptorReader setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger(loggerFactory, this.getClass());
        return this;
    }

    void setLogger(LoggerFactory loggerFactory) {
        this.setLoggerFactory(loggerFactory);
    }

    public DefaultArtifactDescriptorReader setRemoteRepositoryManager(RemoteRepositoryManager remoteRepositoryManager) {
        this.remoteRepositoryManager = Validate.notNull(remoteRepositoryManager, "remoteRepositoryManager cannot be null", new Object[0]);
        return this;
    }

    public DefaultArtifactDescriptorReader setVersionResolver(VersionResolver versionResolver) {
        this.versionResolver = Validate.notNull(versionResolver, "versionResolver cannot be null", new Object[0]);
        return this;
    }

    public DefaultArtifactDescriptorReader setVersionRangeResolver(VersionRangeResolver versionRangeResolver) {
        this.versionRangeResolver = Validate.notNull(versionRangeResolver, "versionRangeResolver cannot be null", new Object[0]);
        return this;
    }

    public DefaultArtifactDescriptorReader setArtifactResolver(ArtifactResolver artifactResolver) {
        this.artifactResolver = Validate.notNull(artifactResolver, "artifactResolver cannot be null", new Object[0]);
        return this;
    }

    public DefaultArtifactDescriptorReader setRepositoryEventDispatcher(RepositoryEventDispatcher repositoryEventDispatcher) {
        this.repositoryEventDispatcher = Validate.notNull(repositoryEventDispatcher, "repositoryEventDispatcher cannot be null", new Object[0]);
        return this;
    }

    public DefaultArtifactDescriptorReader setModelBuilder(ModelBuilder modelBuilder) {
        this.modelBuilder = Validate.notNull(modelBuilder, "modelBuilder cannot be null", new Object[0]);
        return this;
    }

    @Override
    public ArtifactDescriptorResult readArtifactDescriptor(RepositorySystemSession session, ArtifactDescriptorRequest request) throws ArtifactDescriptorException {
        ArtifactDescriptorResult result = new ArtifactDescriptorResult(request);
        Model model = this.loadPom(session, request, result);
        if (model != null) {
            Map<String, Object> config = session.getConfigProperties();
            ArtifactDescriptorReaderDelegate delegate = (ArtifactDescriptorReaderDelegate)config.get(ArtifactDescriptorReaderDelegate.class.getName());
            if (delegate == null) {
                delegate = new ArtifactDescriptorReaderDelegate();
            }
            delegate.populateResult(session, result, model);
        }
        return result;
    }

    private Model loadPom(RepositorySystemSession session, ArtifactDescriptorRequest request, ArtifactDescriptorResult result) throws ArtifactDescriptorException {
        Model model;
        RequestTrace trace = RequestTrace.newChild(request.getTrace(), request);
        LinkedHashSet<String> visited = new LinkedHashSet<String>();
        Artifact a = request.getArtifact();
        while (true) {
            ArtifactResult resolveResult;
            Artifact pomArtifact = ArtifactDescriptorUtils.toPomArtifact(a);
            try {
                VersionRequest versionRequest = new VersionRequest(a, request.getRepositories(), request.getRequestContext());
                versionRequest.setTrace(trace);
                VersionResult versionResult = this.versionResolver.resolveVersion(session, versionRequest);
                a = a.setVersion(versionResult.getVersion());
                versionRequest = new VersionRequest(pomArtifact, request.getRepositories(), request.getRequestContext());
                versionRequest.setTrace(trace);
                versionResult = this.versionResolver.resolveVersion(session, versionRequest);
                pomArtifact = pomArtifact.setVersion(versionResult.getVersion());
            }
            catch (VersionResolutionException e) {
                result.addException(e);
                throw new ArtifactDescriptorException(result);
            }
            if (!visited.add(a.getGroupId() + ':' + a.getArtifactId() + ':' + a.getBaseVersion())) {
                RepositoryException exception = new RepositoryException("Artifact relocations form a cycle: " + visited);
                this.invalidDescriptor(session, trace, a, exception);
                if ((this.getPolicy(session, a, request) & 2) != 0) {
                    return null;
                }
                result.addException(exception);
                throw new ArtifactDescriptorException(result);
            }
            try {
                ArtifactRequest resolveRequest = new ArtifactRequest(pomArtifact, request.getRepositories(), request.getRequestContext());
                resolveRequest.setTrace(trace);
                resolveResult = this.artifactResolver.resolveArtifact(session, resolveRequest);
                pomArtifact = resolveResult.getArtifact();
                result.setRepository(resolveResult.getRepository());
            }
            catch (ArtifactResolutionException e) {
                if (e.getCause() instanceof ArtifactNotFoundException) {
                    this.missingDescriptor(session, trace, a, (Exception)e.getCause());
                    if ((this.getPolicy(session, a, request) & 1) != 0) {
                        return null;
                    }
                }
                result.addException(e);
                throw new ArtifactDescriptorException(result);
            }
            WorkspaceReader workspace = session.getWorkspaceReader();
            if (workspace instanceof MavenWorkspaceReader && (model = ((MavenWorkspaceReader)workspace).findModel(pomArtifact)) != null) {
                return model;
            }
            try {
                DefaultModelBuildingRequest modelRequest = new DefaultModelBuildingRequest();
                modelRequest.setValidationLevel(0);
                modelRequest.setProcessPlugins(false);
                modelRequest.setTwoPhaseBuilding(false);
                modelRequest.setSystemProperties(this.toProperties(session.getUserProperties(), session.getSystemProperties()));
                modelRequest.setModelCache(DefaultModelCache.newInstance(session));
                modelRequest.setModelResolver(new DefaultModelResolver(session, trace.newChild(modelRequest), request.getRequestContext(), this.artifactResolver, this.versionRangeResolver, this.remoteRepositoryManager, request.getRepositories()));
                if (resolveResult.getRepository() instanceof WorkspaceRepository) {
                    modelRequest.setPomFile(pomArtifact.getFile());
                } else {
                    modelRequest.setModelSource(new FileModelSource(pomArtifact.getFile()));
                }
                model = this.modelBuilder.build(modelRequest).getEffectiveModel();
            }
            catch (ModelBuildingException e) {
                for (ModelProblem problem : e.getProblems()) {
                    if (!(problem.getException() instanceof UnresolvableModelException)) continue;
                    result.addException(problem.getException());
                    throw new ArtifactDescriptorException(result);
                }
                this.invalidDescriptor(session, trace, a, e);
                if ((this.getPolicy(session, a, request) & 2) != 0) {
                    return null;
                }
                result.addException(e);
                throw new ArtifactDescriptorException(result);
            }
            Relocation relocation = this.getRelocation(model);
            if (relocation == null) break;
            result.addRelocation(a);
            a = new RelocatedArtifact(a, relocation.getGroupId(), relocation.getArtifactId(), relocation.getVersion());
            result.setArtifact(a);
        }
        return model;
    }

    private Properties toProperties(Map<String, String> dominant, Map<String, String> recessive) {
        Properties props = new Properties();
        if (recessive != null) {
            props.putAll(recessive);
        }
        if (dominant != null) {
            props.putAll(dominant);
        }
        return props;
    }

    private Relocation getRelocation(Model model) {
        Relocation relocation = null;
        DistributionManagement distMgmt = model.getDistributionManagement();
        if (distMgmt != null) {
            relocation = distMgmt.getRelocation();
        }
        return relocation;
    }

    private void missingDescriptor(RepositorySystemSession session, RequestTrace trace, Artifact artifact, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.ARTIFACT_DESCRIPTOR_MISSING);
        event.setTrace(trace);
        event.setArtifact(artifact);
        event.setException(exception);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void invalidDescriptor(RepositorySystemSession session, RequestTrace trace, Artifact artifact, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.ARTIFACT_DESCRIPTOR_INVALID);
        event.setTrace(trace);
        event.setArtifact(artifact);
        event.setException(exception);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private int getPolicy(RepositorySystemSession session, Artifact a, ArtifactDescriptorRequest request) {
        ArtifactDescriptorPolicy policy = session.getArtifactDescriptorPolicy();
        if (policy == null) {
            return 0;
        }
        return policy.getPolicy(session, new ArtifactDescriptorPolicyRequest(a, request.getRequestContext()));
    }
}

