/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.maven.model.io;

import hidden.org.apache.maven.model.InputSource;
import hidden.org.apache.maven.model.Model;
import hidden.org.apache.maven.model.io.ModelParseException;
import hidden.org.apache.maven.model.io.ModelReader;
import hidden.org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import hidden.org.apache.maven.model.io.xpp3.MavenXpp3ReaderEx;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Component(role=ModelReader.class)
public class DefaultModelReader
implements ModelReader {
    @Override
    public Model read(File input, Map<String, ?> options) throws IOException {
        Validate.notNull(input, "input cannot be null", new Object[0]);
        Model model = this.read(new FileInputStream(input), options);
        model.setPomFile(input);
        return model;
    }

    @Override
    public Model read(Reader input, Map<String, ?> options) throws IOException {
        Validate.notNull(input, "input cannot be null", new Object[0]);
        try (Reader in = input;){
            Model model = this.read(in, this.isStrict(options), this.getSource(options));
            return model;
        }
    }

    @Override
    public Model read(InputStream input, Map<String, ?> options) throws IOException {
        Validate.notNull(input, "input cannot be null", new Object[0]);
        try (XmlStreamReader in = ReaderFactory.newXmlReader(input);){
            Model model = this.read(in, this.isStrict(options), this.getSource(options));
            return model;
        }
    }

    private boolean isStrict(Map<String, ?> options) {
        Object value = options != null ? (Object)options.get("hidden.org.apache.maven.model.io.isStrict") : null;
        return value == null || Boolean.parseBoolean(value.toString());
    }

    private InputSource getSource(Map<String, ?> options) {
        Object value = options != null ? options.get("hidden.org.apache.maven.model.io.inputSource") : null;
        return value;
    }

    private Model read(Reader reader, boolean strict, InputSource source) throws IOException {
        try {
            if (source != null) {
                return new MavenXpp3ReaderEx().read(reader, strict, source);
            }
            return new MavenXpp3Reader().read(reader, strict);
        }
        catch (XmlPullParserException e) {
            throw new ModelParseException(e.getMessage(), e.getLineNumber(), e.getColumnNumber(), e);
        }
    }
}

