/*
 * Decompiled with CFR 0.152.
 */
package hidden.com.google.inject.internal;

import hidden.com.google.common.base.Objects;
import hidden.com.google.common.collect.ImmutableSet;
import hidden.com.google.inject.Binder;
import hidden.com.google.inject.Exposed;
import hidden.com.google.inject.Key;
import hidden.com.google.inject.PrivateBinder;
import hidden.com.google.inject.Provider;
import hidden.com.google.inject.Provides;
import hidden.com.google.inject.internal.Exceptions;
import hidden.com.google.inject.internal.util.StackTraceElements;
import hidden.com.google.inject.spi.BindingTargetVisitor;
import hidden.com.google.inject.spi.Dependency;
import hidden.com.google.inject.spi.HasDependencies;
import hidden.com.google.inject.spi.ProviderInstanceBinding;
import hidden.com.google.inject.spi.ProviderWithExtensionVisitor;
import hidden.com.google.inject.spi.ProvidesMethodBinding;
import hidden.com.google.inject.spi.ProvidesMethodTargetVisitor;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Set;

public abstract class ProviderMethod<T>
implements ProviderWithExtensionVisitor<T>,
HasDependencies,
ProvidesMethodBinding<T> {
    protected final Object instance;
    protected final Method method;
    private final Key<T> key;
    private final Class<? extends Annotation> scopeAnnotation;
    private final ImmutableSet<Dependency<?>> dependencies;
    private final List<Provider<?>> parameterProviders;
    private final boolean exposed;
    private final Annotation annotation;

    static <T> ProviderMethod<T> create(Key<T> key, Method method, Object instance, ImmutableSet<Dependency<?>> dependencies, List<Provider<?>> parameterProviders, Class<? extends Annotation> scopeAnnotation, boolean skipFastClassGeneration, Annotation annotation) {
        int modifiers = method.getModifiers();
        if (!Modifier.isPublic(modifiers) || !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            method.setAccessible(true);
        }
        return new ReflectionProviderMethod<T>(key, method, instance, dependencies, parameterProviders, scopeAnnotation, annotation);
    }

    private ProviderMethod(Key<T> key, Method method, Object instance, ImmutableSet<Dependency<?>> dependencies, List<Provider<?>> parameterProviders, Class<? extends Annotation> scopeAnnotation, Annotation annotation) {
        this.key = key;
        this.scopeAnnotation = scopeAnnotation;
        this.instance = instance;
        this.dependencies = dependencies;
        this.method = method;
        this.parameterProviders = parameterProviders;
        this.exposed = method.isAnnotationPresent(Exposed.class);
        this.annotation = annotation;
    }

    @Override
    public Key<T> getKey() {
        return this.key;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    public Object getInstance() {
        return this.instance;
    }

    @Override
    public Object getEnclosingInstance() {
        return this.instance;
    }

    @Override
    public Annotation getAnnotation() {
        return this.annotation;
    }

    public void configure(Binder binder) {
        binder = binder.withSource(this.method);
        if (this.scopeAnnotation != null) {
            binder.bind(this.key).toProvider(this).in(this.scopeAnnotation);
        } else {
            binder.bind(this.key).toProvider(this);
        }
        if (this.exposed) {
            ((PrivateBinder)binder).expose(this.key);
        }
    }

    @Override
    public T get() {
        Object[] parameters = new Object[this.parameterProviders.size()];
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = this.parameterProviders.get(i).get();
        }
        try {
            Object result = this.doProvision(parameters);
            return (T)result;
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw Exceptions.rethrowCause(e);
        }
    }

    abstract Object doProvision(Object[] var1) throws IllegalAccessException, InvocationTargetException;

    @Override
    public Set<Dependency<?>> getDependencies() {
        return this.dependencies;
    }

    @Override
    public <B, V> V acceptExtensionVisitor(BindingTargetVisitor<B, V> visitor, ProviderInstanceBinding<? extends B> binding) {
        if (visitor instanceof ProvidesMethodTargetVisitor) {
            return ((ProvidesMethodTargetVisitor)visitor).visit(this);
        }
        return visitor.visit(binding);
    }

    public String toString() {
        String annotationString = this.annotation.toString();
        if (this.annotation.annotationType() == Provides.class) {
            annotationString = "@Provides";
        } else if (annotationString.endsWith("()")) {
            annotationString = annotationString.substring(0, annotationString.length() - 2);
        }
        String string = String.valueOf(String.valueOf(annotationString));
        String string2 = String.valueOf(String.valueOf(StackTraceElements.forMember(this.method)));
        return new StringBuilder(1 + string.length() + string2.length()).append(string).append(" ").append(string2).toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProviderMethod) {
            ProviderMethod o = (ProviderMethod)obj;
            return this.method.equals(o.method) && this.instance.equals(o.instance) && this.annotation.equals(o.annotation);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.method, this.annotation);
    }

    private static final class ReflectionProviderMethod<T>
    extends ProviderMethod<T> {
        ReflectionProviderMethod(Key<T> key, Method method, Object instance, ImmutableSet<Dependency<?>> dependencies, List<Provider<?>> parameterProviders, Class<? extends Annotation> scopeAnnotation, Annotation annotation) {
            super(key, method, instance, dependencies, parameterProviders, scopeAnnotation, annotation);
        }

        @Override
        Object doProvision(Object[] parameters) throws IllegalAccessException, InvocationTargetException {
            return this.method.invoke(this.instance, parameters);
        }
    }
}

