/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.test;

import java.util.ArrayList;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.core.job.JobExecution;
import org.springframework.batch.core.step.StepExecution;

public abstract class ExecutionContextTestUtils {
    private ExecutionContextTestUtils() {
    }

    public static <T> @Nullable T getValueFromJob(JobExecution jobExecution, String key) {
        return (T)jobExecution.getExecutionContext().get(key);
    }

    public static <T> @Nullable T getValueFromStepInJob(JobExecution jobExecution, String stepName, String key) {
        StepExecution stepExecution = null;
        ArrayList<String> stepNames = new ArrayList<String>();
        for (StepExecution candidate : jobExecution.getStepExecutions()) {
            String name = candidate.getStepName();
            stepNames.add(name);
            if (!name.equals(stepName)) continue;
            stepExecution = candidate;
        }
        if (stepExecution == null) {
            throw new IllegalArgumentException("No such step in this job execution: " + stepName + " not in " + String.valueOf(stepNames));
        }
        Object result = stepExecution.getExecutionContext().get(key);
        return (T)result;
    }

    public static <T> @Nullable T getValueFromStep(StepExecution stepExecution, String key) {
        return (T)stepExecution.getExecutionContext().get(key);
    }
}

