/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.core.job.JobExecution;
import org.springframework.batch.core.job.JobInstance;
import org.springframework.batch.core.job.parameters.JobParameter;
import org.springframework.batch.core.job.parameters.JobParameters;
import org.springframework.batch.core.job.parameters.JobParametersIncrementer;
import org.springframework.batch.core.launch.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.launch.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.launch.JobRestartException;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.infrastructure.item.ExecutionContext;
import org.springframework.dao.OptimisticLockingFailureException;

public class JobRepositoryTestUtils {
    private JobRepository jobRepository;
    private JobParametersIncrementer jobParametersIncrementer = new JobParametersIncrementer(){
        Long count = 0L;

        public JobParameters getNext(@Nullable JobParameters parameters) {
            Long l = this.count;
            this.count = this.count + 1L;
            return new JobParameters(Set.of(new JobParameter("count", (Object)l, Long.class)));
        }
    };

    public JobRepositoryTestUtils(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    public void setJobParametersIncrementer(JobParametersIncrementer jobParametersIncrementer) {
        this.jobParametersIncrementer = jobParametersIncrementer;
    }

    public void setJobRepository(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    public List<JobExecution> createJobExecutions(String jobName, String[] stepNames, int count) throws JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException {
        ArrayList<JobExecution> list = new ArrayList<JobExecution>();
        JobParameters jobParameters = new JobParameters();
        JobInstance jobInstance = this.jobRepository.createJobInstance(jobName, jobParameters);
        for (int i = 0; i < count; ++i) {
            JobParameters nextJobParameters = this.jobParametersIncrementer.getNext(jobParameters);
            JobExecution jobExecution = this.jobRepository.createJobExecution(jobInstance, nextJobParameters, new ExecutionContext());
            for (String stepName : stepNames) {
                this.jobRepository.createStepExecution(stepName, jobExecution);
            }
            list.add(jobExecution);
        }
        return list;
    }

    public List<JobExecution> createJobExecutions(int count) throws JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException {
        return this.createJobExecutions("job", new String[]{"step"}, count);
    }

    public void removeJobExecutions(Collection<JobExecution> jobExecutions) {
        for (JobExecution jobExecution : jobExecutions) {
            this.removeJobExecution(jobExecution);
        }
        for (JobExecution jobExecution : jobExecutions) {
            try {
                this.jobRepository.deleteJobInstance(jobExecution.getJobInstance());
            }
            catch (OptimisticLockingFailureException optimisticLockingFailureException) {}
        }
    }

    public void removeJobExecution(JobExecution jobExecution) {
        this.jobRepository.deleteJobExecution(jobExecution);
    }

    public void removeJobExecutions() {
        List jobNames = this.jobRepository.getJobNames();
        for (String jobName : jobNames) {
            List jobInstances = this.jobRepository.findJobInstances(jobName);
            for (JobInstance jobInstance : jobInstances) {
                List jobExecutions = this.jobRepository.getJobExecutions(jobInstance);
                if (jobExecutions == null || jobExecutions.isEmpty()) continue;
                this.removeJobExecutions(jobExecutions);
            }
        }
    }
}

