/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.batch.core.job.JobExecution;
import org.springframework.batch.core.job.JobInstance;
import org.springframework.batch.core.job.parameters.JobParameter;
import org.springframework.batch.core.job.parameters.JobParameters;
import org.springframework.batch.core.job.parameters.JobParametersIncrementer;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.lang.Nullable;

public class JobRepositoryTestUtils {
    private JobRepository jobRepository;
    private JobParametersIncrementer jobParametersIncrementer = new JobParametersIncrementer(){
        Long count = 0L;

        public JobParameters getNext(@Nullable JobParameters parameters) {
            Long l = this.count;
            this.count = this.count + 1L;
            return new JobParameters(Collections.singletonMap("count", new JobParameter((Object)l, Long.class)));
        }
    };

    public JobRepositoryTestUtils() {
    }

    public JobRepositoryTestUtils(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    public void setJobParametersIncrementer(JobParametersIncrementer jobParametersIncrementer) {
        this.jobParametersIncrementer = jobParametersIncrementer;
    }

    public void setJobRepository(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    public List<JobExecution> createJobExecutions(String jobName, String[] stepNames, int count) throws JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException {
        ArrayList<JobExecution> list = new ArrayList<JobExecution>();
        JobParameters jobParameters = new JobParameters();
        for (int i = 0; i < count; ++i) {
            JobExecution jobExecution = this.jobRepository.createJobExecution(jobName, this.jobParametersIncrementer.getNext(jobParameters));
            list.add(jobExecution);
            for (String stepName : stepNames) {
                this.jobRepository.add(jobExecution.createStepExecution(stepName));
            }
        }
        return list;
    }

    public List<JobExecution> createJobExecutions(int count) throws JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException {
        return this.createJobExecutions("job", new String[]{"step"}, count);
    }

    public void removeJobExecutions(Collection<JobExecution> jobExecutions) {
        for (JobExecution jobExecution : jobExecutions) {
            this.removeJobExecution(jobExecution);
        }
        for (JobExecution jobExecution : jobExecutions) {
            try {
                this.jobRepository.deleteJobInstance(jobExecution.getJobInstance());
            }
            catch (OptimisticLockingFailureException optimisticLockingFailureException) {}
        }
    }

    public void removeJobExecution(JobExecution jobExecution) {
        this.jobRepository.deleteJobExecution(jobExecution);
    }

    public void removeJobExecutions() {
        List jobNames = this.jobRepository.getJobNames();
        for (String jobName : jobNames) {
            int start = 0;
            int count = 100;
            List jobInstances = this.jobRepository.getJobInstances(jobName, start, count);
            while (!jobInstances.isEmpty()) {
                for (JobInstance jobInstance : jobInstances) {
                    List jobExecutions = this.jobRepository.getJobExecutions(jobInstance);
                    if (jobExecutions == null || jobExecutions.isEmpty()) continue;
                    this.removeJobExecutions(jobExecutions);
                }
                jobInstances = this.jobRepository.getJobInstances(jobName, start += count, count);
            }
        }
    }
}

