/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.json;

import org.springframework.batch.infrastructure.item.Chunk;
import org.springframework.batch.infrastructure.item.json.JsonObjectMarshaller;
import org.springframework.batch.infrastructure.item.support.AbstractFileItemWriter;
import org.springframework.core.io.WritableResource;
import org.springframework.util.Assert;

public class JsonFileItemWriter<T>
extends AbstractFileItemWriter<T> {
    private static final char JSON_OBJECT_SEPARATOR = ',';
    private static final char JSON_ARRAY_START = '[';
    private static final char JSON_ARRAY_STOP = ']';
    private JsonObjectMarshaller<T> jsonObjectMarshaller;

    public JsonFileItemWriter(WritableResource resource, JsonObjectMarshaller<T> jsonObjectMarshaller) {
        this.resource = resource;
        Assert.notNull(jsonObjectMarshaller, (String)"json object marshaller must not be null");
        this.jsonObjectMarshaller = jsonObjectMarshaller;
        this.setHeaderCallback(writer -> writer.write(91));
        this.setFooterCallback(writer -> writer.write(this.lineSeparator + "]" + this.lineSeparator));
    }

    public void afterPropertiesSet() throws Exception {
        if (this.append) {
            this.shouldDeleteIfExists = false;
        }
    }

    public void setJsonObjectMarshaller(JsonObjectMarshaller<T> jsonObjectMarshaller) {
        this.jsonObjectMarshaller = jsonObjectMarshaller;
    }

    @Override
    public String doWrite(Chunk<? extends T> items) {
        StringBuilder lines = new StringBuilder();
        Chunk.ChunkIterator iterator = items.iterator();
        if (!items.isEmpty() && this.state.getLinesWritten() > 0L) {
            lines.append(',').append(this.lineSeparator);
        }
        while (iterator.hasNext()) {
            Object item = iterator.next();
            lines.append(' ').append(this.jsonObjectMarshaller.marshal(item));
            if (!iterator.hasNext()) continue;
            lines.append(',').append(this.lineSeparator);
        }
        return lines.toString();
    }
}

