/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.file.mapping;

import java.lang.reflect.Constructor;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.file.mapping.FieldSetMapper;
import org.springframework.batch.infrastructure.item.file.transform.FieldSet;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.util.Assert;

public class RecordFieldSetMapper<T>
implements FieldSetMapper<T> {
    private final SimpleTypeConverter typeConverter = new SimpleTypeConverter();
    private final Constructor<T> mappedConstructor;
    private final @Nullable String[] constructorParameterNames;
    private final Class<?>[] constructorParameterTypes;

    public RecordFieldSetMapper(Class<T> targetType) {
        this(targetType, (ConversionService)new DefaultConversionService());
    }

    public RecordFieldSetMapper(Class<T> targetType, ConversionService conversionService) {
        this.typeConverter.setConversionService(conversionService);
        this.mappedConstructor = BeanUtils.getResolvableConstructor(targetType);
        if (this.mappedConstructor.getParameterCount() > 0) {
            this.constructorParameterNames = BeanUtils.getParameterNames(this.mappedConstructor);
            this.constructorParameterTypes = this.mappedConstructor.getParameterTypes();
        } else {
            this.constructorParameterNames = new String[0];
            this.constructorParameterTypes = new Class[0];
        }
    }

    @Override
    public T mapFieldSet(FieldSet fieldSet) {
        Assert.isTrue((fieldSet.getFieldCount() == this.constructorParameterNames.length ? 1 : 0) != 0, (String)"Fields count must be equal to record components count");
        Assert.isTrue((boolean)fieldSet.hasNames(), (String)"Field names must be specified");
        Object[] args = new Object[this.constructorParameterNames.length];
        for (int i = 0; i < args.length; ++i) {
            String name = this.constructorParameterNames[i];
            Class<?> type = this.constructorParameterTypes[i];
            Assert.notNull((Object)name, (String)"Constructor parameter names must not be null");
            Object converted = this.typeConverter.convertIfNecessary((Object)fieldSet.readRawString(name), type);
            Assert.notNull((Object)converted, () -> String.format("Cannot convert field '%s' to required type '%s'", name, type.getName()));
            args[i] = converted;
        }
        return (T)BeanUtils.instantiateClass(this.mappedConstructor, (Object[])args);
    }
}

