/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.repeat.support;

import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.repeat.RepeatCallback;
import org.springframework.batch.infrastructure.repeat.RepeatContext;
import org.springframework.batch.infrastructure.repeat.RepeatException;
import org.springframework.batch.infrastructure.repeat.RepeatStatus;
import org.springframework.batch.infrastructure.repeat.support.RepeatInternalState;
import org.springframework.batch.infrastructure.repeat.support.RepeatInternalStateSupport;
import org.springframework.batch.infrastructure.repeat.support.RepeatSynchronizationManager;
import org.springframework.batch.infrastructure.repeat.support.RepeatTemplate;
import org.springframework.batch.infrastructure.repeat.support.ResultHolder;
import org.springframework.batch.infrastructure.repeat.support.ResultHolderResultQueue;
import org.springframework.batch.infrastructure.repeat.support.ResultQueue;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.util.Assert;

@Deprecated(since="6.0", forRemoval=true)
public class TaskExecutorRepeatTemplate
extends RepeatTemplate {
    public static final int DEFAULT_THROTTLE_LIMIT = 4;
    private int throttleLimit = 4;
    private TaskExecutor taskExecutor = new SyncTaskExecutor();

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        Assert.notNull((Object)taskExecutor, (String)"A TaskExecutor is required");
        this.taskExecutor = taskExecutor;
    }

    @Override
    protected RepeatStatus getNextResult(RepeatContext context, RepeatCallback callback, RepeatInternalState state) throws Throwable {
        ResultQueue<ResultHolder> queue = ((ResultQueueInternalState)state).getResultQueue();
        do {
            ExecutingRunnable runnable = new ExecutingRunnable(callback, context, queue);
            runnable.expect();
            this.taskExecutor.execute((Runnable)runnable);
            this.update(context);
        } while (queue.isEmpty() && !this.isComplete(context));
        ResultHolder result = queue.take();
        if (result.getError() != null) {
            throw result.getError();
        }
        return Objects.requireNonNull(result.getResult());
    }

    @Override
    protected boolean waitForResults(RepeatInternalState state) {
        ResultQueue<ResultHolder> queue = ((ResultQueueInternalState)state).getResultQueue();
        boolean result = true;
        while (queue.isExpecting()) {
            ResultHolder future;
            try {
                future = queue.take();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RepeatException("InterruptedException while waiting for result.");
            }
            if (future.getError() != null) {
                state.getThrowables().add(future.getError());
                result = false;
                continue;
            }
            RepeatStatus status = future.getResult();
            result = result && this.canContinue(status);
            this.executeAfterInterceptors(future.getContext(), status);
        }
        Assert.state((boolean)queue.isEmpty(), (String)"Future results queue should be empty at end of batch.");
        return result;
    }

    @Override
    protected RepeatInternalState createInternalState(RepeatContext context) {
        return new ResultQueueInternalState(this.throttleLimit);
    }

    private static class ResultQueueInternalState
    extends RepeatInternalStateSupport {
        private final ResultQueue<ResultHolder> results;

        public ResultQueueInternalState(int throttleLimit) {
            this.results = new ResultHolderResultQueue(throttleLimit);
        }

        public ResultQueue<ResultHolder> getResultQueue() {
            return this.results;
        }
    }

    private class ExecutingRunnable
    implements Runnable,
    ResultHolder {
        private final RepeatCallback callback;
        private final RepeatContext context;
        private final ResultQueue<ResultHolder> queue;
        private volatile @Nullable RepeatStatus result;
        private volatile @Nullable Throwable error;

        public ExecutingRunnable(RepeatCallback callback, RepeatContext context, ResultQueue<ResultHolder> queue) {
            this.callback = callback;
            this.context = context;
            this.queue = queue;
        }

        public void expect() {
            try {
                this.queue.expect();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RepeatException("InterruptedException waiting for to acquire lock on input.");
            }
        }

        @Override
        public void run() {
            boolean clearContext = false;
            try {
                if (RepeatSynchronizationManager.getContext() == null) {
                    clearContext = true;
                    RepeatSynchronizationManager.register(this.context);
                }
                if (TaskExecutorRepeatTemplate.this.logger.isDebugEnabled()) {
                    TaskExecutorRepeatTemplate.this.logger.debug((Object)("Repeat operation about to start at count=" + this.context.getStartedCount()));
                }
                this.result = this.callback.doInIteration(this.context);
            }
            catch (Throwable e) {
                this.error = e;
            }
            finally {
                if (clearContext) {
                    RepeatSynchronizationManager.clear();
                }
                this.queue.put(this);
            }
        }

        @Override
        public @Nullable RepeatStatus getResult() {
            return this.result;
        }

        @Override
        public @Nullable Throwable getError() {
            return this.error;
        }

        @Override
        public RepeatContext getContext() {
            return this.context;
        }
    }
}

