/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.support.builder;

import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.support.ScriptItemProcessor;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ScriptItemProcessorBuilder<I, O> {
    private @Nullable String language;
    private @Nullable Resource scriptResource;
    private @Nullable String scriptSource;
    private @Nullable String itemBindingVariableName;

    public ScriptItemProcessorBuilder<I, O> scriptResource(Resource resource) {
        this.scriptResource = resource;
        return this;
    }

    public ScriptItemProcessorBuilder<I, O> language(String language) {
        this.language = language;
        return this;
    }

    public ScriptItemProcessorBuilder<I, O> scriptSource(String scriptSource) {
        this.scriptSource = scriptSource;
        return this;
    }

    public ScriptItemProcessorBuilder<I, O> itemBindingVariableName(String itemBindingVariableName) {
        this.itemBindingVariableName = itemBindingVariableName;
        return this;
    }

    public ScriptItemProcessor<I, O> build() {
        if (this.scriptResource == null && !StringUtils.hasText((String)this.scriptSource)) {
            throw new IllegalArgumentException("scriptResource or scriptSource is required.");
        }
        if (StringUtils.hasText((String)this.scriptSource)) {
            Assert.hasText((String)this.language, (String)"language is required when using scriptSource.");
        }
        ScriptItemProcessor processor = new ScriptItemProcessor();
        if (StringUtils.hasText((String)this.itemBindingVariableName)) {
            processor.setItemBindingVariableName(this.itemBindingVariableName);
        }
        if (this.scriptResource != null) {
            processor.setScript(this.scriptResource);
        }
        if (this.scriptSource != null) {
            Assert.hasText((String)this.language, (String)"Language must contain the script language");
            processor.setScriptSource(this.scriptSource, this.language);
        }
        return processor;
    }
}

