/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.file.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.file.FlatFileFooterCallback;
import org.springframework.batch.infrastructure.item.file.FlatFileHeaderCallback;
import org.springframework.batch.infrastructure.item.file.FlatFileItemWriter;
import org.springframework.batch.infrastructure.item.file.transform.BeanWrapperFieldExtractor;
import org.springframework.batch.infrastructure.item.file.transform.DelimitedLineAggregator;
import org.springframework.batch.infrastructure.item.file.transform.FieldExtractor;
import org.springframework.batch.infrastructure.item.file.transform.FormatterLineAggregator;
import org.springframework.batch.infrastructure.item.file.transform.LineAggregator;
import org.springframework.batch.infrastructure.item.file.transform.RecordFieldExtractor;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.WritableResource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class FlatFileItemWriterBuilder<T> {
    protected Log logger = LogFactory.getLog(this.getClass());
    private @Nullable WritableResource resource;
    private boolean forceSync = false;
    private String lineSeparator = FlatFileItemWriter.DEFAULT_LINE_SEPARATOR;
    private @Nullable LineAggregator<T> lineAggregator;
    private String encoding = FlatFileItemWriter.DEFAULT_CHARSET;
    private boolean shouldDeleteIfExists = true;
    private boolean append = false;
    private boolean shouldDeleteIfEmpty = false;
    private @Nullable FlatFileHeaderCallback headerCallback;
    private @Nullable FlatFileFooterCallback footerCallback;
    private boolean transactional = true;
    private boolean saveState = true;
    private @Nullable String name;
    private @Nullable DelimitedBuilder<T> delimitedBuilder;
    private @Nullable FormattedBuilder<T> formattedBuilder;

    public FlatFileItemWriterBuilder<T> saveState(boolean saveState) {
        this.saveState = saveState;
        return this;
    }

    public FlatFileItemWriterBuilder<T> name(String name) {
        this.name = name;
        return this;
    }

    public FlatFileItemWriterBuilder<T> resource(WritableResource resource) {
        this.resource = resource;
        return this;
    }

    public FlatFileItemWriterBuilder<T> forceSync(boolean forceSync) {
        this.forceSync = forceSync;
        return this;
    }

    public FlatFileItemWriterBuilder<T> lineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
        return this;
    }

    public FlatFileItemWriterBuilder<T> lineAggregator(LineAggregator<T> lineAggregator) {
        this.lineAggregator = lineAggregator;
        return this;
    }

    public FlatFileItemWriterBuilder<T> encoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public FlatFileItemWriterBuilder<T> shouldDeleteIfEmpty(boolean shouldDelete) {
        this.shouldDeleteIfEmpty = shouldDelete;
        return this;
    }

    public FlatFileItemWriterBuilder<T> shouldDeleteIfExists(boolean shouldDelete) {
        this.shouldDeleteIfExists = shouldDelete;
        return this;
    }

    public FlatFileItemWriterBuilder<T> append(boolean append) {
        this.append = append;
        return this;
    }

    public FlatFileItemWriterBuilder<T> headerCallback(FlatFileHeaderCallback callback) {
        this.headerCallback = callback;
        return this;
    }

    public FlatFileItemWriterBuilder<T> footerCallback(FlatFileFooterCallback callback) {
        this.footerCallback = callback;
        return this;
    }

    public FlatFileItemWriterBuilder<T> transactional(boolean transactional) {
        this.transactional = transactional;
        return this;
    }

    public DelimitedBuilder<T> delimited() {
        this.delimitedBuilder = new DelimitedBuilder(this);
        return this.delimitedBuilder;
    }

    public FlatFileItemWriterBuilder<T> delimited(Consumer<DelimitedSpec<T>> config) {
        DelimitedSpecImpl spec = new DelimitedSpecImpl();
        config.accept(spec);
        DelimitedBuilder builder = this.delimited();
        builder.delimiter(spec.delimiter);
        builder.quoteCharacter(spec.quoteCharacter);
        if (spec.sourceType != null) {
            builder.sourceType(spec.sourceType);
        }
        if (spec.fieldExtractor != null) {
            builder.fieldExtractor(spec.fieldExtractor);
        }
        if (!spec.names.isEmpty()) {
            builder.names(spec.names.toArray(new String[0]));
        }
        return this;
    }

    public FormattedBuilder<T> formatted() {
        this.formattedBuilder = new FormattedBuilder(this);
        return this.formattedBuilder;
    }

    public FlatFileItemWriterBuilder<T> formatted(Consumer<FormattedSpec<T>> config) {
        FormattedSpecImpl spec = new FormattedSpecImpl();
        config.accept(spec);
        FormattedBuilder builder = this.formatted();
        if (spec.format != null) {
            builder.format(spec.format);
        }
        builder.locale(spec.locale);
        builder.minimumLength(spec.minimumLength);
        builder.maximumLength(spec.maximumLength);
        if (spec.sourceType != null) {
            builder.sourceType(spec.sourceType);
        }
        if (spec.fieldExtractor != null) {
            builder.fieldExtractor(spec.fieldExtractor);
        }
        if (!spec.names.isEmpty()) {
            builder.names(spec.names.toArray(new String[0]));
        }
        return this;
    }

    public FlatFileItemWriter<T> build() {
        Assert.isTrue((this.lineAggregator != null || this.delimitedBuilder != null || this.formattedBuilder != null ? 1 : 0) != 0, (String)"A LineAggregator or a DelimitedBuilder or a FormattedBuilder is required");
        if (this.saveState) {
            Assert.hasText((String)this.name, (String)"A name is required when saveState is true");
        }
        if (this.resource == null) {
            this.logger.debug((Object)"The resource is null. This is only a valid scenario when injecting it later as in when using the MultiResourceItemWriter");
            this.resource = new FileSystemResource("");
        }
        if (this.lineAggregator == null) {
            Assert.state((this.delimitedBuilder == null || this.formattedBuilder == null ? 1 : 0) != 0, (String)"Either a DelimitedLineAggregator or a FormatterLineAggregator should be provided, but not both");
            if (this.delimitedBuilder != null) {
                this.lineAggregator = this.delimitedBuilder.build();
            } else {
                Assert.state((this.formattedBuilder != null ? 1 : 0) != 0, (String)"A FormattedBuilder is required");
                this.lineAggregator = this.formattedBuilder.build();
            }
        }
        FlatFileItemWriter<T> writer = new FlatFileItemWriter<T>(this.resource, this.lineAggregator);
        if (this.name != null) {
            writer.setName(this.name);
        }
        writer.setAppendAllowed(this.append);
        writer.setEncoding(this.encoding);
        if (this.footerCallback != null) {
            writer.setFooterCallback(this.footerCallback);
        }
        writer.setForceSync(this.forceSync);
        if (this.headerCallback != null) {
            writer.setHeaderCallback(this.headerCallback);
        }
        writer.setLineSeparator(this.lineSeparator);
        if (this.resource != null) {
            writer.setResource(this.resource);
        }
        writer.setSaveState(this.saveState);
        writer.setShouldDeleteIfEmpty(this.shouldDeleteIfEmpty);
        writer.setShouldDeleteIfExists(this.shouldDeleteIfExists);
        writer.setTransactional(this.transactional);
        return writer;
    }

    public static class DelimitedBuilder<T> {
        private final FlatFileItemWriterBuilder<T> parent;
        private final List<String> names = new ArrayList<String>();
        private String delimiter = ",";
        private String quoteCharacter = "";
        private @Nullable FieldExtractor<T> fieldExtractor;
        private @Nullable Class<T> sourceType;

        protected DelimitedBuilder(FlatFileItemWriterBuilder<T> parent) {
            this.parent = parent;
        }

        public DelimitedBuilder<T> delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public DelimitedBuilder<T> sourceType(Class<T> sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public DelimitedBuilder<T> quoteCharacter(String quoteCharacter) {
            this.quoteCharacter = quoteCharacter;
            return this;
        }

        public FlatFileItemWriterBuilder<T> names(String ... names) {
            this.names.addAll(Arrays.asList(names));
            return this.parent;
        }

        public FlatFileItemWriterBuilder<T> fieldExtractor(FieldExtractor<T> fieldExtractor) {
            this.fieldExtractor = fieldExtractor;
            return this.parent;
        }

        public DelimitedLineAggregator<T> build() {
            Assert.isTrue((!this.names.isEmpty() || this.fieldExtractor != null ? 1 : 0) != 0, (String)"A list of field names or a field extractor is required");
            DelimitedLineAggregator<T> delimitedLineAggregator = new DelimitedLineAggregator<T>();
            delimitedLineAggregator.setDelimiter(this.delimiter);
            if (StringUtils.hasLength((String)this.quoteCharacter)) {
                delimitedLineAggregator.setQuoteCharacter(this.quoteCharacter);
            }
            if (this.fieldExtractor == null) {
                if (this.sourceType != null && this.sourceType.isRecord()) {
                    this.fieldExtractor = new RecordFieldExtractor<T>(this.sourceType);
                } else {
                    BeanWrapperFieldExtractor beanWrapperFieldExtractor = new BeanWrapperFieldExtractor(new String[0]);
                    beanWrapperFieldExtractor.setNames(this.names.toArray(new String[0]));
                    try {
                        this.fieldExtractor = beanWrapperFieldExtractor;
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Unable to initialize DelimitedLineAggregator", e);
                    }
                }
            }
            delimitedLineAggregator.setFieldExtractor(this.fieldExtractor);
            return delimitedLineAggregator;
        }
    }

    private static class DelimitedSpecImpl<T>
    implements DelimitedSpec<T> {
        final List<String> names = new ArrayList<String>();
        String delimiter = ",";
        String quoteCharacter = "";
        @Nullable FieldExtractor<T> fieldExtractor;
        @Nullable Class<T> sourceType;

        private DelimitedSpecImpl() {
        }

        @Override
        public DelimitedSpec<T> delimiter(String d) {
            this.delimiter = d;
            return this;
        }

        @Override
        public DelimitedSpec<T> quoteCharacter(String qc) {
            this.quoteCharacter = qc;
            return this;
        }

        @Override
        public DelimitedSpec<T> names(String ... n) {
            this.names.addAll(Arrays.asList(n));
            return this;
        }

        @Override
        public DelimitedSpec<T> fieldExtractor(FieldExtractor<T> fe) {
            this.fieldExtractor = fe;
            return this;
        }

        @Override
        public DelimitedSpec<T> sourceType(Class<T> st) {
            this.sourceType = st;
            return this;
        }
    }

    public static class FormattedBuilder<T> {
        private final FlatFileItemWriterBuilder<T> parent;
        private @Nullable String format;
        private Locale locale = Locale.getDefault();
        private int maximumLength = 0;
        private int minimumLength = 0;
        private @Nullable FieldExtractor<T> fieldExtractor;
        private final List<String> names = new ArrayList<String>();
        private @Nullable Class<T> sourceType;

        protected FormattedBuilder(FlatFileItemWriterBuilder<T> parent) {
            this.parent = parent;
        }

        public FormattedBuilder<T> format(String format) {
            this.format = format;
            return this;
        }

        public FormattedBuilder<T> locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public FormattedBuilder<T> minimumLength(int minimumLength) {
            this.minimumLength = minimumLength;
            return this;
        }

        public FormattedBuilder<T> maximumLength(int maximumLength) {
            this.maximumLength = maximumLength;
            return this;
        }

        public FormattedBuilder<T> sourceType(Class<T> sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public FlatFileItemWriterBuilder<T> fieldExtractor(FieldExtractor<T> fieldExtractor) {
            this.fieldExtractor = fieldExtractor;
            return this.parent;
        }

        public FlatFileItemWriterBuilder<T> names(String ... names) {
            this.names.addAll(Arrays.asList(names));
            return this.parent;
        }

        public FormatterLineAggregator<T> build() {
            Assert.notNull((Object)this.format, (String)"A format is required");
            Assert.isTrue((!this.names.isEmpty() || this.fieldExtractor != null ? 1 : 0) != 0, (String)"A list of field names or a field extractor is required");
            FormatterLineAggregator<T> formatterLineAggregator = new FormatterLineAggregator<T>(this.format);
            formatterLineAggregator.setLocale(this.locale);
            formatterLineAggregator.setMinimumLength(this.minimumLength);
            formatterLineAggregator.setMaximumLength(this.maximumLength);
            if (this.fieldExtractor == null) {
                if (this.sourceType != null && this.sourceType.isRecord()) {
                    this.fieldExtractor = new RecordFieldExtractor<T>(this.sourceType);
                } else {
                    BeanWrapperFieldExtractor beanWrapperFieldExtractor = new BeanWrapperFieldExtractor(new String[0]);
                    beanWrapperFieldExtractor.setNames(this.names.toArray(new String[0]));
                    try {
                        this.fieldExtractor = beanWrapperFieldExtractor;
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Unable to initialize FormatterLineAggregator", e);
                    }
                }
            }
            formatterLineAggregator.setFieldExtractor(this.fieldExtractor);
            return formatterLineAggregator;
        }
    }

    private static class FormattedSpecImpl<T>
    implements FormattedSpec<T> {
        @Nullable String format;
        Locale locale = Locale.getDefault();
        int minimumLength = 0;
        int maximumLength = 0;
        final List<String> names = new ArrayList<String>();
        @Nullable FieldExtractor<T> fieldExtractor;
        @Nullable Class<T> sourceType;

        private FormattedSpecImpl() {
        }

        @Override
        public FormattedSpec<T> format(String f) {
            this.format = f;
            return this;
        }

        @Override
        public FormattedSpec<T> locale(Locale l) {
            this.locale = l;
            return this;
        }

        @Override
        public FormattedSpec<T> minimumLength(int min) {
            this.minimumLength = min;
            return this;
        }

        @Override
        public FormattedSpec<T> maximumLength(int max) {
            this.maximumLength = max;
            return this;
        }

        @Override
        public FormattedSpec<T> names(String ... n) {
            this.names.addAll(Arrays.asList(n));
            return this;
        }

        @Override
        public FormattedSpec<T> fieldExtractor(FieldExtractor<T> fe) {
            this.fieldExtractor = fe;
            return this;
        }

        @Override
        public FormattedSpec<T> sourceType(Class<T> st) {
            this.sourceType = st;
            return this;
        }
    }

    public static interface FormattedSpec<T> {
        public FormattedSpec<T> format(String var1);

        public FormattedSpec<T> locale(Locale var1);

        public FormattedSpec<T> minimumLength(int var1);

        public FormattedSpec<T> maximumLength(int var1);

        public FormattedSpec<T> names(String ... var1);

        public FormattedSpec<T> fieldExtractor(FieldExtractor<T> var1);

        public FormattedSpec<T> sourceType(Class<T> var1);
    }

    public static interface DelimitedSpec<T> {
        public DelimitedSpec<T> delimiter(String var1);

        public DelimitedSpec<T> quoteCharacter(String var1);

        public DelimitedSpec<T> names(String ... var1);

        public DelimitedSpec<T> fieldExtractor(FieldExtractor<T> var1);

        public DelimitedSpec<T> sourceType(Class<T> var1);
    }
}

