/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.data.builder;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.data.RepositoryItemReader;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RepositoryItemReaderBuilder<T> {
    private @Nullable PagingAndSortingRepository<?, ?> repository;
    private @Nullable Map<String, // Could not load outer class - annotation placement on inner may be incorrect
    Sort.Direction> sorts;
    private @Nullable List<?> arguments;
    private int pageSize = 10;
    private @Nullable String methodName;
    private boolean saveState = true;
    private @Nullable String name;
    private int maxItemCount = Integer.MAX_VALUE;
    private int currentItemCount;

    public RepositoryItemReaderBuilder<T> saveState(boolean saveState) {
        this.saveState = saveState;
        return this;
    }

    public RepositoryItemReaderBuilder<T> name(String name) {
        this.name = name;
        return this;
    }

    public RepositoryItemReaderBuilder<T> maxItemCount(int maxItemCount) {
        this.maxItemCount = maxItemCount;
        return this;
    }

    public RepositoryItemReaderBuilder<T> currentItemCount(int currentItemCount) {
        this.currentItemCount = currentItemCount;
        return this;
    }

    public RepositoryItemReaderBuilder<T> arguments(List<?> arguments) {
        this.arguments = arguments;
        return this;
    }

    public RepositoryItemReaderBuilder<T> arguments(Object ... arguments) {
        return this.arguments(Arrays.asList(arguments));
    }

    public RepositoryItemReaderBuilder<T> sorts(Map<String, Sort.Direction> sorts) {
        this.sorts = sorts;
        return this;
    }

    public RepositoryItemReaderBuilder<T> pageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public RepositoryItemReaderBuilder<T> repository(PagingAndSortingRepository<?, ?> repository) {
        this.repository = repository;
        return this;
    }

    public RepositoryItemReaderBuilder<T> methodName(String methodName) {
        this.methodName = methodName;
        return this;
    }

    public RepositoryItemReader<T> build() {
        Assert.notNull(this.sorts, (String)"sorts map is required.");
        Assert.notNull(this.repository, (String)"repository is required.");
        Assert.isTrue((this.pageSize > 0 ? 1 : 0) != 0, (String)"Page size must be greater than 0");
        Assert.hasText((String)this.methodName, (String)"methodName is required.");
        if (this.saveState) {
            Assert.state((boolean)StringUtils.hasText((String)this.name), (String)"A name is required when saveState is set to true.");
        }
        RepositoryItemReader reader = new RepositoryItemReader(this.repository, this.sorts);
        if (this.arguments != null) {
            reader.setArguments(this.arguments);
        }
        reader.setRepository(this.repository);
        reader.setMethodName(this.methodName);
        reader.setPageSize(this.pageSize);
        reader.setCurrentItemCount(this.currentItemCount);
        reader.setMaxItemCount(this.maxItemCount);
        reader.setSaveState(this.saveState);
        if (this.name != null) {
            reader.setName(this.name);
        }
        return reader;
    }
}

