/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.json;

import org.springframework.batch.infrastructure.item.ItemStreamException;
import org.springframework.batch.infrastructure.item.json.JsonObjectMarshaller;
import tools.jackson.core.JacksonException;
import tools.jackson.databind.json.JsonMapper;

public class JacksonJsonObjectMarshaller<T>
implements JsonObjectMarshaller<T> {
    private JsonMapper jsonMapper;

    public JacksonJsonObjectMarshaller() {
        this(new JsonMapper());
    }

    public JacksonJsonObjectMarshaller(JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
    }

    public void setJsonMapper(JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
    }

    @Override
    public String marshal(T item) {
        try {
            return this.jsonMapper.writeValueAsString(item);
        }
        catch (JacksonException e) {
            throw new ItemStreamException("Unable to marshal object " + String.valueOf(item) + " to Json", e);
        }
    }
}

