/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.support;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.ItemReader;
import org.springframework.util.Assert;

public class SynchronizedItemReader<T>
implements ItemReader<T> {
    private final ItemReader<T> delegate;
    private final Lock lock = new ReentrantLock();

    public SynchronizedItemReader(ItemReader<T> delegate) {
        Assert.notNull(delegate, (String)"The delegate must not be null");
        this.delegate = delegate;
    }

    @Override
    public @Nullable T read() throws Exception {
        this.lock.lock();
        try {
            T t = this.delegate.read();
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }
}

