/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.mail.builder;

import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.mail.DefaultMailErrorHandler;
import org.springframework.batch.infrastructure.item.mail.MailErrorHandler;
import org.springframework.batch.infrastructure.item.mail.SimpleMailMessageItemWriter;
import org.springframework.mail.MailSender;
import org.springframework.util.Assert;

public class SimpleMailMessageItemWriterBuilder {
    private @Nullable MailSender mailSender;
    private MailErrorHandler mailErrorHandler = new DefaultMailErrorHandler();

    public SimpleMailMessageItemWriterBuilder mailSender(MailSender mailSender) {
        this.mailSender = mailSender;
        return this;
    }

    public SimpleMailMessageItemWriterBuilder mailErrorHandler(MailErrorHandler mailErrorHandler) {
        this.mailErrorHandler = mailErrorHandler;
        return this;
    }

    public SimpleMailMessageItemWriter build() {
        Assert.notNull((Object)this.mailSender, (String)"A mailSender is required");
        SimpleMailMessageItemWriter writer = new SimpleMailMessageItemWriter(this.mailSender);
        writer.setMailSender(this.mailSender);
        writer.setMailErrorHandler(this.mailErrorHandler);
        return writer;
    }
}

