/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.batch.infrastructure.item.ItemStreamException;
import org.springframework.batch.infrastructure.item.json.JsonObjectMarshaller;

public class JacksonJsonObjectMarshaller<T>
implements JsonObjectMarshaller<T> {
    private ObjectMapper objectMapper;

    public JacksonJsonObjectMarshaller() {
        this(new ObjectMapper());
    }

    public JacksonJsonObjectMarshaller(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public String marshal(T item) {
        try {
            return this.objectMapper.writeValueAsString(item);
        }
        catch (JsonProcessingException e) {
            throw new ItemStreamException("Unable to marshal object " + String.valueOf(item) + " to Json", e);
        }
    }
}

