/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.data;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.bson.BsonReader;
import org.bson.Document;
import org.bson.codecs.DecoderContext;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.support.AbstractItemCountingItemStreamItemReader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.util.json.ParameterBindingDocumentCodec;
import org.springframework.data.mongodb.util.json.ParameterBindingJsonReader;
import org.springframework.data.util.CloseableIterator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class MongoCursorItemReader<T>
extends AbstractItemCountingItemStreamItemReader<T>
implements InitializingBean {
    private MongoOperations template;
    private Class<? extends T> targetType;
    private @Nullable String collection;
    private @Nullable Query query;
    private @Nullable String queryString;
    private List<Object> parameterValues = new ArrayList<Object>();
    private @Nullable String fields;
    private @Nullable Sort sort;
    private @Nullable String hint;
    private int batchSize;
    private int limit;
    private @Nullable Duration maxTime;
    private @Nullable CloseableIterator<? extends T> cursor;

    public MongoCursorItemReader(MongoOperations template, Class<? extends T> targetType) {
        Assert.notNull((Object)template, (String)"MongoOperations must not be null");
        Assert.notNull(targetType, (String)"Target type must not be null");
        this.template = template;
        this.targetType = targetType;
    }

    public void setTemplate(MongoOperations template) {
        this.template = template;
    }

    public void setTargetType(Class<? extends T> targetType) {
        this.targetType = targetType;
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public void setQuery(String queryString) {
        this.queryString = queryString;
    }

    public void setParameterValues(List<Object> parameterValues) {
        Assert.notNull(parameterValues, (String)"Parameter values must not be null");
        this.parameterValues = parameterValues;
    }

    public void setFields(String fields) {
        this.fields = fields;
    }

    public void setSort(Map<String, Sort.Direction> sorts) {
        Assert.notNull(sorts, (String)"Sorts must not be null");
        this.sort = this.convertToSort(sorts);
    }

    public void setHint(String hint) {
        this.hint = hint;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setMaxTime(Duration maxTime) {
        Assert.notNull((Object)maxTime, (String)"maxTime must not be null.");
        this.maxTime = maxTime;
    }

    public void afterPropertiesSet() {
        Assert.state((this.queryString != null || this.query != null ? 1 : 0) != 0, (String)"A query is required.");
        if (this.queryString != null) {
            Assert.state((this.sort != null ? 1 : 0) != 0, (String)"A sort is required.");
        }
    }

    @Override
    protected void doOpen() throws Exception {
        Query mongoQuery = this.queryString != null ? this.createQuery() : this.query;
        Stream stream = StringUtils.hasText((String)this.collection) ? this.template.stream(mongoQuery, this.targetType, this.collection) : this.template.stream(mongoQuery, this.targetType);
        this.cursor = this.streamToIterator(stream);
    }

    private Query createQuery() {
        String populatedQuery = this.replacePlaceholders(this.queryString, this.parameterValues);
        BasicQuery mongoQuery = StringUtils.hasText((String)this.fields) ? new BasicQuery(populatedQuery, this.fields) : new BasicQuery(populatedQuery);
        if (this.sort != null) {
            mongoQuery.with(this.sort);
        }
        if (StringUtils.hasText((String)this.hint)) {
            mongoQuery.withHint(this.hint);
        }
        mongoQuery.cursorBatchSize(this.batchSize);
        mongoQuery.limit(this.limit);
        if (this.maxTime != null) {
            mongoQuery.maxTime(this.maxTime);
        } else {
            mongoQuery.noCursorTimeout();
        }
        return mongoQuery;
    }

    @Override
    protected T doRead() throws Exception {
        return (T)(this.cursor.hasNext() ? this.cursor.next() : null);
    }

    @Override
    protected void doClose() throws Exception {
        this.cursor.close();
    }

    private Sort convertToSort(Map<String, Sort.Direction> sorts) {
        ArrayList<Sort.Order> sortValues = new ArrayList<Sort.Order>(sorts.size());
        for (Map.Entry<String, Sort.Direction> curSort : sorts.entrySet()) {
            sortValues.add(new Sort.Order(curSort.getValue(), curSort.getKey()));
        }
        return Sort.by(sortValues);
    }

    private String replacePlaceholders(String input, List<Object> values) {
        ParameterBindingJsonReader reader = new ParameterBindingJsonReader(input, values.toArray());
        DecoderContext decoderContext = DecoderContext.builder().build();
        Document document = new ParameterBindingDocumentCodec().decode((BsonReader)reader, decoderContext);
        return document.toJson();
    }

    private CloseableIterator<? extends T> streamToIterator(final Stream<? extends T> stream) {
        return new CloseableIterator<T>(){
            private final Iterator<? extends T> delegate;
            {
                this.delegate = stream.iterator();
            }

            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            public T next() {
                return this.delegate.next();
            }

            public void close() {
                stream.close();
            }
        };
    }
}

