/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.repeat.exception;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.exception.ExceptionHandler;
import org.springframework.classify.Classifier;
import org.springframework.classify.ClassifierSupport;

public class LogOrRethrowExceptionHandler
implements ExceptionHandler {
    protected final Log logger = LogFactory.getLog(LogOrRethrowExceptionHandler.class);
    private Classifier<Throwable, Level> exceptionClassifier = new ClassifierSupport((Object)Level.RETHROW);

    public void setExceptionClassifier(Classifier<Throwable, Level> exceptionClassifier) {
        this.exceptionClassifier = exceptionClassifier;
    }

    @Override
    public void handleException(RepeatContext context, Throwable throwable) throws Throwable {
        Level key = (Level)((Object)this.exceptionClassifier.classify((Object)throwable));
        if (Level.ERROR.equals((Object)key)) {
            this.logger.error((Object)"Exception encountered in batch repeat.", throwable);
        } else if (Level.WARN.equals((Object)key)) {
            this.logger.warn((Object)"Exception encountered in batch repeat.", throwable);
        } else if (Level.DEBUG.equals((Object)key) && this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Exception encountered in batch repeat.", throwable);
        } else if (Level.RETHROW.equals((Object)key)) {
            throw throwable;
        }
    }

    public static enum Level {
        RETHROW,
        DEBUG,
        WARN,
        ERROR;

    }
}

