/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file.transform;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.RecordComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.batch.item.file.transform.FieldExtractor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class RecordFieldExtractor<T>
implements FieldExtractor<T> {
    private List<String> names;
    private Class<? extends T> targetType;
    private RecordComponent[] recordComponents;

    public RecordFieldExtractor(Class<? extends T> targetType) {
        Assert.notNull(targetType, (String)"target type must not be null");
        Assert.isTrue((boolean)targetType.isRecord(), (String)"target type must be a record");
        this.targetType = targetType;
        this.recordComponents = this.targetType.getRecordComponents();
        this.names = this.getRecordComponentNames();
    }

    public void setNames(String ... names) {
        Assert.notNull((Object)names, (String)"Names must not be null");
        Assert.notEmpty((Object[])names, (String)"Names must not be empty");
        this.validate(names);
        this.names = Arrays.stream(names).toList();
    }

    @Override
    public Object[] extract(T item) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (String componentName : this.names) {
            RecordComponent recordComponent = this.getRecordComponentByName(componentName);
            try {
                Object value = recordComponent.getAccessor().invoke(item, new Object[0]);
                values.add(value);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Unable to extract value for record component " + componentName, e);
            }
        }
        return values.toArray();
    }

    private List<String> getRecordComponentNames() {
        return Arrays.stream(this.recordComponents).map(recordComponent -> recordComponent.getName()).toList();
    }

    private void validate(String[] names) {
        for (String name : names) {
            if (this.getRecordComponentByName(name) != null) continue;
            throw new IllegalArgumentException("Component '" + name + "' is not defined in record " + this.targetType.getName());
        }
    }

    @Nullable
    private RecordComponent getRecordComponentByName(String name) {
        return Arrays.stream(this.recordComponents).filter(recordComponent -> recordComponent.getName().equals(name)).findFirst().orElse(null);
    }
}

