/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.springframework.batch.item.database.AbstractCursorItemReader;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class JdbcCursorItemReader<T>
extends AbstractCursorItemReader<T> {
    PreparedStatement preparedStatement;
    PreparedStatementSetter preparedStatementSetter;
    String sql;
    RowMapper rowMapper;

    public JdbcCursorItemReader() {
        this.setName(ClassUtils.getShortName(JdbcCursorItemReader.class));
    }

    public void setRowMapper(RowMapper rowMapper) {
        this.rowMapper = rowMapper;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setPreparedStatementSetter(PreparedStatementSetter preparedStatementSetter) {
        this.preparedStatementSetter = preparedStatementSetter;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.sql, (String)"The SQL query must be provided");
        Assert.notNull((Object)this.rowMapper, (String)"RowMapper must be provided");
    }

    @Override
    protected void openCursor(Connection con) {
        try {
            this.preparedStatement = this.isUseSharedExtendedConnection() ? con.prepareStatement(this.sql, 1003, 1007, 1) : con.prepareStatement(this.sql, 1003, 1007);
            this.applyStatementSettings(this.preparedStatement);
            if (this.preparedStatementSetter != null) {
                this.preparedStatementSetter.setValues(this.preparedStatement);
            }
            this.rs = this.preparedStatement.executeQuery();
            this.handleWarnings(this.preparedStatement);
        }
        catch (SQLException se) {
            this.close();
            throw this.getExceptionTranslator().translate("Executing query", this.getSql(), se);
        }
    }

    @Override
    protected T readCursor(ResultSet rs, int currentRow) throws SQLException {
        return (T)this.rowMapper.mapRow(rs, currentRow);
    }

    @Override
    protected void cleanupOnClose() throws Exception {
        JdbcUtils.closeStatement((Statement)this.preparedStatement);
    }

    @Override
    public String getSql() {
        return this.sql;
    }
}

