/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.ItemReaderException;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.ReaderNotOpenException;
import org.springframework.batch.item.file.FlatFileParseException;
import org.springframework.batch.item.file.ResourceAwareItemReaderItemStream;
import org.springframework.batch.item.file.mapping.FieldSet;
import org.springframework.batch.item.file.mapping.FieldSetMapper;
import org.springframework.batch.item.file.separator.LineReader;
import org.springframework.batch.item.file.separator.RecordSeparatorPolicy;
import org.springframework.batch.item.file.separator.ResourceLineReader;
import org.springframework.batch.item.file.transform.AbstractLineTokenizer;
import org.springframework.batch.item.file.transform.DelimitedLineTokenizer;
import org.springframework.batch.item.file.transform.LineTokenizer;
import org.springframework.batch.item.support.AbstractBufferedItemReaderItemStream;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class FlatFileItemReader
extends AbstractBufferedItemReaderItemStream
implements ResourceAwareItemReaderItemStream,
InitializingBean {
    private static Log log = LogFactory.getLog((Class)FlatFileItemReader.class);
    public static final String DEFAULT_CHARSET = "ISO-8859-1";
    private String encoding = "ISO-8859-1";
    private Resource resource;
    private RecordSeparatorPolicy recordSeparatorPolicy;
    private String[] comments;
    private int linesToSkip = 0;
    private boolean firstLineIsHeader = false;
    private LineTokenizer tokenizer = new DelimitedLineTokenizer();
    private FieldSetMapper fieldSetMapper;
    private LineReader reader;
    private boolean noInput = false;

    public FlatFileItemReader() {
        this.setName(ClassUtils.getShortName((Class)FlatFileItemReader.class));
    }

    private String readLine() {
        try {
            return (String)this.getReader().read();
        }
        catch (ItemStreamException e) {
            throw e;
        }
        catch (ItemReaderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException();
        }
    }

    protected LineReader getReader() {
        if (this.reader == null) {
            throw new ReaderNotOpenException("Reader must be open before it can be read.");
        }
        return this.reader;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public void setRecordSeparatorPolicy(RecordSeparatorPolicy recordSeparatorPolicy) {
        this.recordSeparatorPolicy = recordSeparatorPolicy;
    }

    public void setComments(String[] comments) {
        this.comments = new String[comments.length];
        System.arraycopy(comments, 0, this.comments, 0, comments.length);
    }

    public void setFirstLineIsHeader(boolean firstLineIsHeader) {
        this.firstLineIsHeader = firstLineIsHeader;
    }

    public void setLineTokenizer(LineTokenizer lineTokenizer) {
        this.tokenizer = lineTokenizer;
    }

    public void setFieldSetMapper(FieldSetMapper fieldSetMapper) {
        this.fieldSetMapper = fieldSetMapper;
    }

    public void setLinesToSkip(int linesToSkip) {
        this.linesToSkip = linesToSkip;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.fieldSetMapper, (String)"FieldSetMapper must not be null.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doClose() throws Exception {
        try {
            if (this.reader != null) {
                log.debug((Object)("Closing flat file for reading: " + this.resource));
                this.reader.close();
            }
        }
        finally {
            this.reader = null;
        }
    }

    protected void doOpen() throws Exception {
        Assert.notNull((Object)this.resource, (String)"Input Resource must not be null");
        this.noInput = false;
        if (!this.resource.exists()) {
            this.noInput = true;
            log.warn((Object)"Input resource does not exist");
            return;
        }
        log.debug((Object)("Opening flat file for reading: " + this.resource));
        if (this.reader == null) {
            ResourceLineReader reader = new ResourceLineReader(this.resource, this.encoding);
            if (this.recordSeparatorPolicy != null) {
                reader.setRecordSeparatorPolicy(this.recordSeparatorPolicy);
            }
            if (this.comments != null) {
                reader.setComments(this.comments);
            }
            reader.open();
            this.reader = reader;
        }
        for (int i = 0; i < this.linesToSkip; ++i) {
            this.readLine();
        }
        if (this.firstLineIsHeader) {
            String firstLine = this.readLine();
            if (this.tokenizer instanceof AbstractLineTokenizer && !((AbstractLineTokenizer)this.tokenizer).hasNames()) {
                String[] names = this.tokenizer.tokenize(firstLine).getValues();
                ((AbstractLineTokenizer)this.tokenizer).setNames(names);
            }
        }
    }

    protected Object doRead() throws Exception {
        if (this.noInput) {
            return null;
        }
        String line = this.readLine();
        if (line != null) {
            int lineCount = this.getReader().getPosition();
            try {
                FieldSet tokenizedLine = this.tokenizer.tokenize(line);
                return this.fieldSetMapper.mapLine(tokenizedLine);
            }
            catch (RuntimeException ex) {
                throw new FlatFileParseException("Parsing error at line: " + lineCount + " in resource=" + this.resource.getDescription() + ", input=[" + line + "]", (Throwable)ex, line, lineCount);
            }
        }
        return null;
    }
}

