/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database;

import java.util.HashSet;
import java.util.Set;
import org.springframework.batch.item.ClearFailedException;
import org.springframework.batch.item.FlushFailedException;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.repeat.support.RepeatSynchronizationManager;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public abstract class AbstractTransactionalResourceItemWriter
implements ItemWriter {
    private Set failed = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws FlushFailedException {
        this.bindTransactionResources();
        try {
            this.doFlush();
        }
        catch (RuntimeException e) {
            Set set = this.failed;
            synchronized (set) {
                this.failed.addAll(this.getProcessed());
            }
            throw e;
        }
        finally {
            this.unbindTransactionResources();
        }
    }

    public void write(Object output) throws Exception {
        this.bindTransactionResources();
        this.getProcessed().add(output);
        this.doWrite(output);
        this.flushIfNecessary(output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushIfNecessary(Object output) {
        boolean flush;
        Set set = this.failed;
        synchronized (set) {
            flush = this.failed.contains(output);
        }
        if (flush) {
            RepeatSynchronizationManager.setCompleteOnly();
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws ClearFailedException {
        try {
            this.doClear();
        }
        finally {
            this.unbindTransactionResources();
        }
    }

    protected abstract void doFlush() throws FlushFailedException;

    protected abstract void doClear() throws ClearFailedException;

    protected abstract void doWrite(Object var1) throws Exception;

    protected abstract String getResourceKey();

    private void bindTransactionResources() {
        if (TransactionSynchronizationManager.hasResource((Object)this.getResourceKey())) {
            return;
        }
        TransactionSynchronizationManager.bindResource((Object)this.getResourceKey(), new HashSet());
    }

    private void unbindTransactionResources() {
        if (!TransactionSynchronizationManager.hasResource((Object)this.getResourceKey())) {
            return;
        }
        TransactionSynchronizationManager.unbindResource((Object)this.getResourceKey());
    }

    protected Set getProcessed() {
        Assert.state((boolean)TransactionSynchronizationManager.hasResource((Object)this.getResourceKey()), (String)"Processed items not bound to transaction.");
        Set processed = (Set)TransactionSynchronizationManager.getResource((Object)this.getResourceKey());
        return processed;
    }
}

