/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.experimental.core.step.item;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.ItemProcessListener;
import org.springframework.batch.core.ItemReadListener;
import org.springframework.batch.core.ItemWriteListener;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.AbstractStep;
import org.springframework.batch.core.step.FatalStepExecutionException;
import org.springframework.batch.core.step.StepInterruptionPolicy;
import org.springframework.batch.core.step.ThreadStepInterruptionPolicy;
import org.springframework.batch.experimental.core.step.item.ChunkListener;
import org.springframework.batch.item.Chunk;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.support.CompositeItemStream;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;

public class ChunkOrientedStep<I, O>
extends AbstractStep {
    private static final Log logger = LogFactory.getLog((String)ChunkOrientedStep.class.getName());
    private final ItemReader<I> itemReader;
    private ItemReadListener<I> itemReadListener = new ItemReadListener<I>(){};
    private final ItemProcessor<I, O> itemProcessor;
    private ItemProcessListener<I, O> itemProcessListener = new ItemProcessListener<I, O>(){};
    private final ItemWriter<O> itemWriter;
    private ItemWriteListener<O> itemWriteListener = new ItemWriteListener<O>(){};
    private final TransactionTemplate transactionTemplate;
    private final TransactionAttribute transactionAttribute = new DefaultTransactionAttribute(){

        public boolean rollbackOn(Throwable ex) {
            return true;
        }
    };
    private final int chunkSize;
    private final ChunkTracker chunkTracker = new ChunkTracker();
    private ChunkListener<O> chunkListener = new ChunkListener<O>(){};
    private final CompositeItemStream stream = new CompositeItemStream();
    private StepInterruptionPolicy interruptionPolicy = new ThreadStepInterruptionPolicy();

    public ChunkOrientedStep(String name, int chunkSize, ItemReader<I> itemReader, ItemProcessor<I, O> itemProcessor, ItemWriter<O> itemWriter, JobRepository jobRepository, PlatformTransactionManager transactionManager) {
        super(name);
        ItemStream itemStream;
        Assert.isTrue((chunkSize > 0 ? 1 : 0) != 0, (String)"Chunk size must be greater than 0");
        this.setJobRepository(jobRepository);
        this.itemReader = itemReader;
        this.itemProcessor = itemProcessor;
        this.itemWriter = itemWriter;
        this.transactionTemplate = new TransactionTemplate(transactionManager, (TransactionDefinition)this.transactionAttribute);
        this.chunkSize = chunkSize;
        ItemReader<I> itemReader2 = this.itemReader;
        if (itemReader2 instanceof ItemStream) {
            itemStream = (ItemStream)itemReader2;
            this.stream.register(itemStream);
        }
        if ((itemReader2 = this.itemProcessor) instanceof ItemStream) {
            itemStream = (ItemStream)itemReader2;
            this.stream.register(itemStream);
        }
        if ((itemReader2 = this.itemWriter) instanceof ItemStream) {
            itemStream = (ItemStream)itemReader2;
            this.stream.register(itemStream);
        }
    }

    public ChunkOrientedStep(String name, int chunkSize, ItemReader<I> itemReader, ItemWriter<O> itemWriter, JobRepository jobRepository, PlatformTransactionManager transactionManager) {
        this(name, chunkSize, itemReader, item -> item, itemWriter, jobRepository, transactionManager);
    }

    protected void doExecute(final StepExecution stepExecution) throws Exception {
        while (this.chunkTracker.moreItems()) {
            this.interruptionPolicy.checkInterrupted(stepExecution);
            this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    StepContribution contribution = stepExecution.createStepContribution();
                    Chunk inputChunk = new Chunk(new Object[0]);
                    Chunk processedChunk = new Chunk(new Object[0]);
                    try {
                        ChunkOrientedStep.this.chunkListener.beforeChunk();
                        inputChunk = ChunkOrientedStep.this.read(contribution);
                        processedChunk = ChunkOrientedStep.this.process(inputChunk, contribution);
                        ChunkOrientedStep.this.write(processedChunk, contribution);
                        ChunkOrientedStep.this.chunkListener.afterChunk(processedChunk);
                        stepExecution.apply(contribution);
                        stepExecution.incrementCommitCount();
                        ChunkOrientedStep.this.stream.update(stepExecution.getExecutionContext());
                        ChunkOrientedStep.this.getJobRepository().update(stepExecution);
                        ChunkOrientedStep.this.getJobRepository().updateExecutionContext(stepExecution);
                    }
                    catch (Exception e) {
                        logger.error((Object)"Rolling back chunk transaction", (Throwable)e);
                        status.setRollbackOnly();
                        stepExecution.incrementRollbackCount();
                        ChunkOrientedStep.this.chunkListener.onChunkError(e, processedChunk);
                        throw new FatalStepExecutionException("Unable to process chunk", (Throwable)e);
                    }
                }
            });
        }
    }

    private Chunk<I> read(StepContribution contribution) throws Exception {
        Chunk chunk = new Chunk(new Object[0]);
        for (int i = 0; i < this.chunkSize; ++i) {
            this.itemReadListener.beforeRead();
            try {
                Object item = this.itemReader.read();
                if (item == null) {
                    this.chunkTracker.noMoreItems();
                    break;
                }
                chunk.add(item);
                contribution.incrementReadCount();
                this.itemReadListener.afterRead(item);
                continue;
            }
            catch (Exception exception) {
                this.itemReadListener.onReadError(exception);
                throw exception;
            }
        }
        return chunk;
    }

    private Chunk<O> process(Chunk<I> chunk, StepContribution contribution) throws Exception {
        Chunk processedChunk = new Chunk(new Object[0]);
        for (Object item : chunk) {
            try {
                this.itemProcessListener.beforeProcess(item);
                Object processedItem = this.itemProcessor.process(item);
                this.itemProcessListener.afterProcess(item, processedItem);
                if (processedItem == null) {
                    contribution.incrementFilterCount(1L);
                    continue;
                }
                processedChunk.add(processedItem);
            }
            catch (Exception exception) {
                this.itemProcessListener.onProcessError(item, exception);
                throw exception;
            }
        }
        return processedChunk;
    }

    private void write(Chunk<O> chunk, StepContribution contribution) throws Exception {
        try {
            this.itemWriteListener.beforeWrite(chunk);
            this.itemWriter.write(chunk);
            contribution.incrementWriteCount((long)chunk.size());
            this.itemWriteListener.afterWrite(chunk);
        }
        catch (Exception e) {
            this.itemWriteListener.onWriteError(e, chunk);
            throw e;
        }
    }

    protected void open(ExecutionContext executionContext) throws Exception {
        this.stream.open(executionContext);
    }

    protected void close(ExecutionContext executionContext) throws Exception {
        this.stream.close();
    }

    public void setInterruptionPolicy(StepInterruptionPolicy interruptionPolicy) {
        this.interruptionPolicy = interruptionPolicy;
    }

    public void registerStream(ItemStream stream) {
        this.stream.register(stream);
    }

    public void setItemReadListener(ItemReadListener<I> itemReadListener) {
        this.itemReadListener = itemReadListener;
    }

    public void setItemProcessListener(ItemProcessListener<I, O> itemProcessListener) {
        this.itemProcessListener = itemProcessListener;
    }

    public void setItemWriteListener(ItemWriteListener<O> itemWriteListener) {
        this.itemWriteListener = itemWriteListener;
    }

    public void setChunkListener(ChunkListener<O> chunkListener) {
        this.chunkListener = chunkListener;
    }

    public void setTransactionAttribute(TransactionAttribute transactionAttribute) {
        this.transactionTemplate.setIsolationLevel(transactionAttribute.getIsolationLevel());
        this.transactionTemplate.setPropagationBehavior(transactionAttribute.getPropagationBehavior());
        this.transactionTemplate.setTimeout(transactionAttribute.getTimeout());
    }

    private static class ChunkTracker {
        private boolean moreItems = true;

        private ChunkTracker() {
        }

        void noMoreItems() {
            this.moreItems = false;
        }

        boolean moreItems() {
            return this.moreItems;
        }
    }
}

