/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.experimental.core.repository.dao;

import java.util.List;
import org.springframework.batch.core.DefaultJobKeyGenerator;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobKeyGenerator;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.core.repository.dao.JobInstanceDao;
import org.springframework.batch.experimental.core.repository.dao.MongoSequenceIncrementer;
import org.springframework.batch.experimental.core.repository.persistence.converter.JobInstanceConverter;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;
import org.springframework.util.Assert;

public class MongoJobInstanceDao
implements JobInstanceDao {
    private static final String COLLECTION_NAME = "BATCH_JOB_INSTANCE";
    private static final String SEQUENCE_NAME = "BATCH_JOB_INSTANCE_SEQ";
    private final MongoOperations mongoOperations;
    private JobKeyGenerator<JobParameters> jobKeyGenerator = new DefaultJobKeyGenerator();
    private DataFieldMaxValueIncrementer jobInstanceIncrementer;
    private final JobInstanceConverter jobInstanceConverter = new JobInstanceConverter();

    public MongoJobInstanceDao(MongoOperations mongoOperations) {
        Assert.notNull((Object)mongoOperations, (String)"mongoOperations must not be null.");
        this.mongoOperations = mongoOperations;
        this.jobInstanceIncrementer = new MongoSequenceIncrementer(mongoOperations, SEQUENCE_NAME);
    }

    public void setJobInstanceIncrementer(DataFieldMaxValueIncrementer jobInstanceIncrementer) {
        this.jobInstanceIncrementer = jobInstanceIncrementer;
    }

    public JobInstance createJobInstance(String jobName, JobParameters jobParameters) {
        Assert.notNull((Object)jobName, (String)"Job name must not be null.");
        Assert.notNull((Object)jobParameters, (String)"JobParameters must not be null.");
        Assert.state((this.getJobInstance(jobName, jobParameters) == null ? 1 : 0) != 0, (String)"JobInstance must not already exist");
        org.springframework.batch.experimental.core.repository.persistence.JobInstance jobInstanceToSave = new org.springframework.batch.experimental.core.repository.persistence.JobInstance();
        jobInstanceToSave.setJobName(jobName);
        String key = this.jobKeyGenerator.generateKey((Object)jobParameters);
        jobInstanceToSave.setJobKey(key);
        long instanceId = this.jobInstanceIncrementer.nextLongValue();
        jobInstanceToSave.setJobInstanceId(instanceId);
        this.mongoOperations.insert((Object)jobInstanceToSave, COLLECTION_NAME);
        JobInstance jobInstance = new JobInstance(Long.valueOf(instanceId), jobName);
        jobInstance.incrementVersion();
        return jobInstance;
    }

    public JobInstance getJobInstance(String jobName, JobParameters jobParameters) {
        String key = this.jobKeyGenerator.generateKey((Object)jobParameters);
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"jobName").is((Object)jobName).and("jobKey").is((Object)key));
        org.springframework.batch.experimental.core.repository.persistence.JobInstance jobInstance = (org.springframework.batch.experimental.core.repository.persistence.JobInstance)this.mongoOperations.findOne(query, org.springframework.batch.experimental.core.repository.persistence.JobInstance.class, COLLECTION_NAME);
        return jobInstance != null ? this.jobInstanceConverter.toJobInstance(jobInstance) : null;
    }

    public JobInstance getJobInstance(Long instanceId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"jobInstanceId").is((Object)instanceId));
        org.springframework.batch.experimental.core.repository.persistence.JobInstance jobInstance = (org.springframework.batch.experimental.core.repository.persistence.JobInstance)this.mongoOperations.findOne(query, org.springframework.batch.experimental.core.repository.persistence.JobInstance.class, COLLECTION_NAME);
        return jobInstance != null ? this.jobInstanceConverter.toJobInstance(jobInstance) : null;
    }

    public JobInstance getJobInstance(JobExecution jobExecution) {
        return this.getJobInstance(jobExecution.getJobId());
    }

    public List<JobInstance> getJobInstances(String jobName, int start, int count) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"jobName").is((Object)jobName));
        Sort.Order sortOrder = Sort.Order.desc((String)"jobInstanceId");
        List jobInstances = this.mongoOperations.find(query.with(Sort.by((Sort.Order[])new Sort.Order[]{sortOrder})), org.springframework.batch.experimental.core.repository.persistence.JobInstance.class, COLLECTION_NAME).stream().toList();
        return jobInstances.subList(start, jobInstances.size()).stream().map(this.jobInstanceConverter::toJobInstance).limit(count).toList();
    }

    public JobInstance getLastJobInstance(String jobName) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"jobName").is((Object)jobName));
        Sort.Order sortOrder = Sort.Order.desc((String)"jobInstanceId");
        org.springframework.batch.experimental.core.repository.persistence.JobInstance jobInstance = (org.springframework.batch.experimental.core.repository.persistence.JobInstance)this.mongoOperations.findOne(query.with(Sort.by((Sort.Order[])new Sort.Order[]{sortOrder})), org.springframework.batch.experimental.core.repository.persistence.JobInstance.class, COLLECTION_NAME);
        return jobInstance != null ? this.jobInstanceConverter.toJobInstance(jobInstance) : null;
    }

    public List<String> getJobNames() {
        return this.mongoOperations.findAll(org.springframework.batch.experimental.core.repository.persistence.JobInstance.class, COLLECTION_NAME).stream().map(org.springframework.batch.experimental.core.repository.persistence.JobInstance::getJobName).toList();
    }

    public List<JobInstance> findJobInstancesByName(String jobName, int start, int count) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"jobName").alike(Example.of((Object)jobName)));
        Sort.Order sortOrder = Sort.Order.desc((String)"jobInstanceId");
        List jobInstances = this.mongoOperations.find(query.with(Sort.by((Sort.Order[])new Sort.Order[]{sortOrder})), org.springframework.batch.experimental.core.repository.persistence.JobInstance.class, COLLECTION_NAME).stream().toList();
        return jobInstances.subList(start, jobInstances.size()).stream().map(this.jobInstanceConverter::toJobInstance).limit(count).toList();
    }

    public long getJobInstanceCount(String jobName) throws NoSuchJobException {
        if (!this.getJobNames().contains(jobName)) {
            throw new NoSuchJobException("Job not found " + jobName);
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"jobName").is((Object)jobName));
        return this.mongoOperations.count(query, COLLECTION_NAME);
    }

    public void setJobKeyGenerator(JobKeyGenerator<JobParameters> jobKeyGenerator) {
        this.jobKeyGenerator = jobKeyGenerator;
    }
}

