/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.service;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.admin.service.FileInfo;
import org.springframework.batch.admin.service.FileSender;
import org.springframework.batch.admin.service.FileService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ContextResource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalFileService
implements FileService,
InitializingBean,
ResourceLoaderAware {
    private File outputDir = new File(System.getProperty("java.io.tmpdir", "/tmp"), "batch/files");
    private static final Log logger = LogFactory.getLog(LocalFileService.class);
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private FileSender fileSender;

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setFileSender(FileSender fileSender) {
        this.fileSender = fileSender;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.fileSender != null ? 1 : 0) != 0, (String)"A FileSender must be provided");
        if (!this.outputDir.exists()) {
            Assert.state((boolean)this.outputDir.mkdirs(), (String)("Cannot create output directory " + this.outputDir));
        }
        Assert.state((boolean)this.outputDir.exists(), (String)("Output directory does not exist " + this.outputDir));
        Assert.state((boolean)this.outputDir.isDirectory(), (String)("Output file is not a directory " + this.outputDir));
    }

    @Override
    public FileInfo createFile(String path) throws IOException {
        path = this.sanitize(path);
        Assert.hasText((String)path, (String)"The file path must not be empty");
        String name = path.substring(path.lastIndexOf("/") + 1);
        String parent = path.substring(0, path.lastIndexOf(name));
        if (parent.endsWith("/")) {
            parent = parent.substring(0, parent.length() - 1);
        }
        File directory = new File(this.outputDir, parent);
        directory.mkdirs();
        Assert.state((directory.exists() && directory.isDirectory() ? 1 : 0) != 0, (String)("Could not create directory: " + directory));
        FileInfo result = new FileInfo(path);
        File dest = new File(this.outputDir, result.getFileName());
        dest.createNewFile();
        return result;
    }

    private String extractPath(File target) {
        String outputPath = this.outputDir.getAbsolutePath();
        return target.getAbsolutePath().substring(outputPath.length() + 1).replace("\\", "/");
    }

    @Override
    public boolean publish(FileInfo dest) throws IOException {
        String path = dest.getPath();
        this.fileSender.send(this.getResource(path).getFile());
        return true;
    }

    @Override
    public int countFiles() {
        Resource[] resources;
        ResourcePatternResolver resolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)this.resourceLoader);
        try {
            resources = resolver.getResources("file:///" + this.outputDir.getAbsolutePath() + "/**");
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected problem resolving files", e);
        }
        return resources.length;
    }

    @Override
    public List<FileInfo> getFiles(int startFile, int pageSize) throws IOException {
        List<FileInfo> files = this.getFiles("**");
        String path = "";
        int count = 0;
        for (FileInfo info : files) {
            FileInfo shortInfo = info.shortPath();
            if (!path.equals(shortInfo.getPath())) {
                files.set(count, shortInfo);
                path = shortInfo.getPath();
            }
            ++count;
        }
        return new ArrayList<FileInfo>(files.subList(startFile, Math.min(startFile + pageSize, files.size())));
    }

    private List<FileInfo> getFiles(String pattern) {
        ResourcePatternResolver resolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)this.resourceLoader);
        List<Object> resources = new ArrayList();
        if (!pattern.startsWith("/")) {
            pattern = "/" + this.outputDir.getAbsolutePath() + "/" + pattern;
        }
        if (!pattern.startsWith("file:")) {
            pattern = "file:///" + pattern;
        }
        try {
            resources = Arrays.asList(resolver.getResources(pattern));
        }
        catch (IOException e) {
            logger.debug((Object)("Cannot locate files " + pattern), (Throwable)e);
            return new ArrayList<FileInfo>();
        }
        ArrayList<FileInfo> files = new ArrayList<FileInfo>();
        for (Resource resource : resources) {
            try {
                File file = resource.getFile();
                if (!file.isFile()) continue;
                FileInfo info = new FileInfo(this.extractPath(file));
                files.add(info);
            }
            catch (IOException e) {
                logger.debug((Object)("Cannot locate file " + resource), (Throwable)e);
            }
        }
        Collections.sort(files);
        return new ArrayList<FileInfo>(files);
    }

    @Override
    public int delete(String pattern) throws IOException {
        ResourcePatternResolver resolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)this.resourceLoader);
        if (!pattern.startsWith("/")) {
            pattern = "/" + this.outputDir.getAbsolutePath() + "/" + pattern;
        }
        if (!pattern.startsWith("file:")) {
            pattern = "file:///" + pattern;
        }
        Resource[] resources = resolver.getResources(pattern);
        int count = 0;
        for (Resource resource : resources) {
            File file = resource.getFile();
            if (!file.isFile()) continue;
            ++count;
            FileUtils.deleteQuietly((File)file);
        }
        return count;
    }

    @Override
    public Resource getResource(String path) {
        FileInfo pattern = new FileInfo(path = this.sanitize(path));
        List<FileInfo> files = this.getFiles(pattern.getPattern());
        FileInfo info = files.isEmpty() ? pattern : files.get(0);
        File file = new File(this.outputDir, info.getFileName());
        return new FileServiceResource(file, path);
    }

    public File getUploadDirectory() {
        return this.outputDir;
    }

    private String sanitize(String path) {
        if ((path = path.replace("\\", "/")).startsWith("files:")) {
            path = path.substring("files:".length());
            while (path.startsWith("/")) {
                path = path.substring(1);
            }
        }
        return path;
    }

    private static class FileServiceResource
    extends FileSystemResource
    implements ContextResource {
        private final String path;

        public FileServiceResource(File file, String path) {
            super(file);
            this.path = path;
        }

        public String getPathWithinContext() {
            return this.path;
        }
    }
}

