/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.extensions.excel.streaming;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.eventusermodel.XSSFSheetXMLHandler;
import org.apache.poi.xssf.model.SharedStrings;
import org.apache.poi.xssf.model.Styles;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.springframework.batch.extensions.excel.Sheet;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.StaxUtils;
import org.xml.sax.Attributes;

class StreamingSheet
implements Sheet {
    private final Log logger = LogFactory.getLog(StreamingSheet.class);
    private final String name;
    private final InputStream is;
    private final XMLStreamReader reader;
    private final ValueRetrievingContentsHandler contentHandler;
    private final XSSFSheetXMLHandler sheetHandler;
    private int rowCount;
    private int colCount;

    StreamingSheet(String name, InputStream is, SharedStrings sharedStrings, Styles styles, DataFormatter dataFormatter) {
        this.name = name;
        this.is = is;
        this.contentHandler = new ValueRetrievingContentsHandler();
        this.sheetHandler = new XSSFSheetXMLHandler(styles, sharedStrings, (XSSFSheetXMLHandler.SheetContentsHandler)this.contentHandler, dataFormatter, false);
        try {
            this.reader = StaxUtils.createDefensiveInputFactory().createXMLStreamReader(is);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public int getNumberOfRows() {
        return this.rowCount;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String[] getRow(int rowNumber) {
        throw new UnsupportedOperationException("Getting row by index not supported when streaming.");
    }

    private String[] nextRow() {
        try {
            while (this.reader.hasNext()) {
                int type = this.reader.next();
                if (type == 7) {
                    this.sheetHandler.startDocument();
                    continue;
                }
                if (type == 8) {
                    this.sheetHandler.endDocument();
                    return null;
                }
                if (type == 4) {
                    this.sheetHandler.characters(this.reader.getTextCharacters(), this.reader.getTextStart(), this.reader.getTextLength());
                    continue;
                }
                if (type == 1) {
                    String localName = this.reader.getLocalName();
                    if ("dimension".equals(localName)) {
                        String v = this.reader.getAttributeValue(null, "ref");
                        if (v == null || v.indexOf(58) <= -1) continue;
                        CellRangeAddress range = CellRangeAddress.valueOf((String)v);
                        int rowEnd = range.getLastRow();
                        int rowStart = range.getFirstRow();
                        this.rowCount = rowEnd - rowStart + 1;
                        int colStart = range.getFirstColumn();
                        int colEnd = range.getLastColumn();
                        this.colCount = colEnd - colStart + 1;
                        continue;
                    }
                    AttributesAdapter delegating = new AttributesAdapter(this.reader);
                    this.sheetHandler.startElement(null, localName, null, (Attributes)delegating);
                    continue;
                }
                if (type != 2) continue;
                String tag = this.reader.getLocalName();
                this.sheetHandler.endElement(null, tag, null);
                if (!"row".equals(tag)) continue;
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Row ended, returning: " + StringUtils.arrayToCommaDelimitedString((Object[])this.contentHandler.getValues())));
                }
                return this.contentHandler.getValues();
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error reading file.", ex);
        }
        return null;
    }

    @Override
    public void close() throws Exception {
        try {
            this.reader.close();
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
        this.is.close();
    }

    @Override
    public Iterator<String[]> iterator() {
        return new Iterator<String[]>(){
            private String[] currentRow;

            @Override
            public boolean hasNext() {
                this.currentRow = StreamingSheet.this.nextRow();
                return this.currentRow != null;
            }

            @Override
            public String[] next() {
                return this.currentRow;
            }
        };
    }

    private class ValueRetrievingContentsHandler
    implements XSSFSheetXMLHandler.SheetContentsHandler {
        private final Log logger = LogFactory.getLog(ValueRetrievingContentsHandler.class);
        private String[] values;

        private ValueRetrievingContentsHandler() {
        }

        public void startRow(int rowNum) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Start processing row: " + rowNum));
            }
            if (this.values == null) {
                this.values = new String[StreamingSheet.this.colCount];
            }
            Arrays.fill(this.values, "");
        }

        public void endRow(int rowNum) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("End processing row: " + rowNum));
            }
        }

        public void cell(String cellReference, String formattedValue, XSSFComment comment) {
            short col = new CellReference(cellReference).getCol();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Setting value (" + cellReference + ") = " + formattedValue));
            }
            if (this.values.length <= col) {
                String[] newValues = Arrays.copyOf(this.values, col + 1);
                Arrays.setAll(newValues, idx -> newValues[idx] != null ? newValues[idx] : "");
                this.values = newValues;
            }
            this.values[col] = formattedValue;
        }

        String[] getValues() {
            return Arrays.copyOf(this.values, this.values.length);
        }
    }

    private static final class AttributesAdapter
    implements Attributes {
        private final Map<String, String> attributes;

        private AttributesAdapter(XMLStreamReader delegate) {
            this.attributes = CollectionUtils.newHashMap((int)delegate.getAttributeCount());
            for (int i = 0; i < delegate.getAttributeCount(); ++i) {
                String name = delegate.getAttributeLocalName(i);
                String value = delegate.getAttributeValue(i);
                this.attributes.put(name, value);
            }
        }

        @Override
        public int getLength() {
            return this.attributes.size();
        }

        @Override
        public String getURI(int index) {
            return null;
        }

        @Override
        public String getLocalName(int index) {
            return null;
        }

        @Override
        public String getQName(int index) {
            return null;
        }

        @Override
        public String getType(int index) {
            return null;
        }

        @Override
        public String getValue(int index) {
            return null;
        }

        @Override
        public int getIndex(String uri, String localName) {
            return 0;
        }

        @Override
        public int getIndex(String qName) {
            return 0;
        }

        @Override
        public String getType(String uri, String localName) {
            return null;
        }

        @Override
        public String getType(String qName) {
            return null;
        }

        @Override
        public String getValue(String uri, String localName) {
            return this.attributes.get(localName);
        }

        @Override
        public String getValue(String qName) {
            return this.attributes.get(qName);
        }
    }
}

