/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.extensions.excel.poi;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.springframework.batch.extensions.excel.FormulaEvaluatorFactory;
import org.springframework.batch.extensions.excel.Sheet;
import org.springframework.lang.Nullable;

class PoiSheet
implements Sheet {
    private final DataFormatter dataFormatter;
    private final org.apache.poi.ss.usermodel.Sheet delegate;
    private final int numberOfRows;
    private final String name;
    private final FormulaEvaluatorFactory formulaEvaluatorFactory;
    private FormulaEvaluator evaluator;

    PoiSheet(org.apache.poi.ss.usermodel.Sheet delegate, DataFormatter dataFormatter, FormulaEvaluatorFactory formulaEvaluatorFactory) {
        this.delegate = delegate;
        this.numberOfRows = this.delegate.getLastRowNum() + 1;
        this.name = this.delegate.getSheetName();
        this.dataFormatter = dataFormatter;
        this.formulaEvaluatorFactory = formulaEvaluatorFactory;
    }

    @Override
    public int getNumberOfRows() {
        return this.numberOfRows;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String[] getRow(int rowNumber) {
        Row row = this.delegate.getRow(rowNumber);
        return this.map(row);
    }

    @Nullable
    private String[] map(Row row) {
        if (row == null) {
            return null;
        }
        ArrayList<String> cells = new ArrayList<String>();
        int numberOfColumns = row.getLastCellNum();
        for (int i = 0; i < numberOfColumns; ++i) {
            Cell cell = row.getCell(i);
            CellType cellType = cell.getCellType();
            if (cellType == CellType.FORMULA) {
                cells.add(this.dataFormatter.formatCellValue(cell, this.getFormulaEvaluator()));
                continue;
            }
            cells.add(this.dataFormatter.formatCellValue(cell));
        }
        return cells.toArray(new String[0]);
    }

    private FormulaEvaluator getFormulaEvaluator() {
        if (this.evaluator == null) {
            this.evaluator = this.formulaEvaluatorFactory.create(this.delegate.getWorkbook());
        }
        return this.evaluator;
    }

    @Override
    public Iterator<String[]> iterator() {
        return new Iterator<String[]>(){
            private final Iterator<Row> delegateIter;
            {
                this.delegateIter = PoiSheet.this.delegate.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.delegateIter.hasNext();
            }

            @Override
            public String[] next() {
                return PoiSheet.this.map(this.delegateIter.next());
            }
        };
    }
}

