/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.AbstractBufferingClientHttpRequest;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.OkHttpClientHttpResponse;
import org.springframework.util.StringUtils;
import org.springframework.web.client.HttpClientErrorException;

class OkHttpClientHttpRequest
extends AbstractBufferingClientHttpRequest
implements ClientHttpRequest {
    private static final String PROXY_AUTH_ERROR = "Received HTTP_PROXY_AUTH (407) code while not using proxy";
    private final OkHttpClient client;
    private final URI uri;
    private final HttpMethod method;

    public OkHttpClientHttpRequest(OkHttpClient client, URI uri, HttpMethod method) {
        this.client = client;
        this.uri = uri;
        this.method = method;
    }

    @Override
    public HttpMethod getMethod() {
        return this.method;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    protected ClientHttpResponse executeInternal(HttpHeaders headers, byte[] content) throws IOException {
        MediaType contentType = this.getContentType(headers);
        RequestBody body = content.length > 0 ? RequestBody.create((MediaType)contentType, (byte[])content) : null;
        URL url = this.uri.toURL();
        String methodName = this.method.name();
        Request.Builder builder = new Request.Builder().url(url).method(methodName, body);
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String headerName = entry.getKey();
            for (String headerValue : entry.getValue()) {
                builder.addHeader(headerName, headerValue);
            }
        }
        Request request = builder.build();
        Response response = null;
        try {
            response = this.client.newCall(request).execute();
        }
        catch (ProtocolException e) {
            if (PROXY_AUTH_ERROR.equals(e.getMessage())) {
                throw new HttpClientErrorException(HttpStatus.PROXY_AUTHENTICATION_REQUIRED, HttpStatus.PROXY_AUTHENTICATION_REQUIRED.getReasonPhrase());
            }
            throw e;
        }
        return new OkHttpClientHttpResponse(response);
    }

    private MediaType getContentType(HttpHeaders headers) {
        String rawContentType = headers.getFirst("Content-Type");
        return StringUtils.hasText((String)rawContentType) ? MediaType.parse((String)rawContentType) : null;
    }
}

