/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.springframework.http.ContentCodingType;
import org.springframework.http.client.ClientHttpResponse;

public abstract class AbstractClientHttpResponse
implements ClientHttpResponse {
    public InputStream getBody() throws IOException {
        InputStream body = this.getBodyInternal();
        if (body == null) {
            return null;
        }
        List<ContentCodingType> contentCodingTypes = this.getHeaders().getContentEncoding();
        for (ContentCodingType contentCodingType : contentCodingTypes) {
            if (!contentCodingType.equals(ContentCodingType.GZIP)) continue;
            return new GZIPInputStream(body);
        }
        return body;
    }

    protected abstract InputStream getBodyInternal() throws IOException;
}

