/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.utility.Utility;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.AmqpAuthenticationException;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.AmqpIOException;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.connection.ChannelProxy;
import org.springframework.amqp.rabbit.connection.ClosingRecoveryListener;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactoryUtils;
import org.springframework.amqp.rabbit.connection.RabbitResourceHolder;
import org.springframework.amqp.rabbit.connection.RabbitUtils;
import org.springframework.amqp.rabbit.listener.ConsumeOkEvent;
import org.springframework.amqp.rabbit.listener.MessageAckListener;
import org.springframework.amqp.rabbit.listener.QueuesNotAvailableException;
import org.springframework.amqp.rabbit.listener.exception.FatalListenerStartupException;
import org.springframework.amqp.rabbit.listener.support.ContainerUtils;
import org.springframework.amqp.rabbit.support.ActiveObjectCounter;
import org.springframework.amqp.rabbit.support.ConsumerCancelledException;
import org.springframework.amqp.rabbit.support.Delivery;
import org.springframework.amqp.rabbit.support.MessagePropertiesConverter;
import org.springframework.amqp.rabbit.support.RabbitExceptionTranslator;
import org.springframework.amqp.support.ConsumerTagStrategy;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.backoff.BackOffExecution;

public class BlockingQueueConsumer {
    private static final int DEFAULT_DECLARATION_RETRIES = 3;
    private static final int DEFAULT_RETRY_DECLARATION_INTERVAL = 60000;
    private static final Log logger = LogFactory.getLog(BlockingQueueConsumer.class);
    private final Lock lifecycleLock = new ReentrantLock();
    private final BlockingQueue<Delivery> queue;
    private volatile @Nullable ShutdownSignalException shutdown;
    private final String[] queues;
    private final int prefetchCount;
    private final boolean transactional;
    private Channel channel;
    private RabbitResourceHolder resourceHolder;
    private final ConcurrentMap<String, InternalConsumer> consumers = new ConcurrentHashMap<String, InternalConsumer>();
    private final AtomicBoolean cancelled = new AtomicBoolean(false);
    private final AcknowledgeMode acknowledgeMode;
    private final ConnectionFactory connectionFactory;
    private final MessagePropertiesConverter messagePropertiesConverter;
    private final ActiveObjectCounter<BlockingQueueConsumer> activeObjectCounter;
    private final Map<String, Object> consumerArgs = new HashMap<String, Object>();
    private final boolean noLocal;
    private final boolean exclusive;
    private final Set<Long> deliveryTags = new LinkedHashSet<Long>();
    private final boolean defaultRequeueRejected;
    private final Set<String> missingQueues = ConcurrentHashMap.newKeySet();
    private final Lock missingQueuesLock = new ReentrantLock();
    private long retryDeclarationInterval = 60000L;
    private long failedDeclarationRetryInterval = 5000L;
    private int declarationRetries = 3;
    private long lastRetryDeclaration;
    private @Nullable ConsumerTagStrategy tagStrategy;
    private BackOffExecution backOffExecution;
    private long shutdownTimeout;
    private boolean locallyTransacted;
    private @Nullable ApplicationEventPublisher applicationEventPublisher;
    private long consumeDelay;
    private Consumer<String> missingQueuePublisher = str -> {};
    private boolean globalQos;
    private volatile long abortStarted;
    private volatile boolean normalCancel;
    volatile Thread thread;
    volatile boolean declaring;
    private @Nullable MessageAckListener messageAckListener;

    public BlockingQueueConsumer(ConnectionFactory connectionFactory, MessagePropertiesConverter messagePropertiesConverter, ActiveObjectCounter<BlockingQueueConsumer> activeObjectCounter, AcknowledgeMode acknowledgeMode, boolean transactional, int prefetchCount, String ... queues) {
        this(connectionFactory, messagePropertiesConverter, activeObjectCounter, acknowledgeMode, transactional, prefetchCount, true, queues);
    }

    public BlockingQueueConsumer(ConnectionFactory connectionFactory, MessagePropertiesConverter messagePropertiesConverter, ActiveObjectCounter<BlockingQueueConsumer> activeObjectCounter, AcknowledgeMode acknowledgeMode, boolean transactional, int prefetchCount, boolean defaultRequeueRejected, String ... queues) {
        this(connectionFactory, messagePropertiesConverter, activeObjectCounter, acknowledgeMode, transactional, prefetchCount, defaultRequeueRejected, (Map<String, Object>)null, queues);
    }

    public BlockingQueueConsumer(ConnectionFactory connectionFactory, MessagePropertiesConverter messagePropertiesConverter, ActiveObjectCounter<BlockingQueueConsumer> activeObjectCounter, AcknowledgeMode acknowledgeMode, boolean transactional, int prefetchCount, boolean defaultRequeueRejected, @Nullable Map<String, Object> consumerArgs, String ... queues) {
        this(connectionFactory, messagePropertiesConverter, activeObjectCounter, acknowledgeMode, transactional, prefetchCount, defaultRequeueRejected, consumerArgs, false, queues);
    }

    public BlockingQueueConsumer(ConnectionFactory connectionFactory, MessagePropertiesConverter messagePropertiesConverter, ActiveObjectCounter<BlockingQueueConsumer> activeObjectCounter, AcknowledgeMode acknowledgeMode, boolean transactional, int prefetchCount, boolean defaultRequeueRejected, @Nullable Map<String, Object> consumerArgs, boolean exclusive, String ... queues) {
        this(connectionFactory, messagePropertiesConverter, activeObjectCounter, acknowledgeMode, transactional, prefetchCount, defaultRequeueRejected, consumerArgs, false, exclusive, queues);
    }

    public BlockingQueueConsumer(ConnectionFactory connectionFactory, MessagePropertiesConverter messagePropertiesConverter, ActiveObjectCounter<BlockingQueueConsumer> activeObjectCounter, AcknowledgeMode acknowledgeMode, boolean transactional, int prefetchCount, boolean defaultRequeueRejected, @Nullable Map<String, Object> consumerArgs, boolean noLocal, boolean exclusive, String ... queues) {
        this.connectionFactory = connectionFactory;
        this.messagePropertiesConverter = messagePropertiesConverter;
        this.activeObjectCounter = activeObjectCounter;
        this.acknowledgeMode = acknowledgeMode;
        this.transactional = transactional;
        this.prefetchCount = prefetchCount;
        this.defaultRequeueRejected = defaultRequeueRejected;
        if (!CollectionUtils.isEmpty(consumerArgs)) {
            this.consumerArgs.putAll(consumerArgs);
        }
        this.noLocal = noLocal;
        this.exclusive = exclusive;
        this.queues = Arrays.copyOf(queues, queues.length);
        this.queue = new LinkedBlockingQueue<Delivery>(queues.length == 0 ? prefetchCount : prefetchCount * queues.length);
    }

    public Channel getChannel() {
        return this.channel;
    }

    public Collection<String> getConsumerTags() {
        return this.consumers.values().stream().map(DefaultConsumer::getConsumerTag).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void setShutdownTimeout(long shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
    }

    public void setDeclarationRetries(int declarationRetries) {
        this.declarationRetries = declarationRetries;
    }

    public void setFailedDeclarationRetryInterval(long failedDeclarationRetryInterval) {
        this.failedDeclarationRetryInterval = failedDeclarationRetryInterval;
    }

    public void setRetryDeclarationInterval(long retryDeclarationInterval) {
        this.retryDeclarationInterval = retryDeclarationInterval;
    }

    public void setTagStrategy(ConsumerTagStrategy tagStrategy) {
        this.tagStrategy = tagStrategy;
    }

    public void setBackOffExecution(BackOffExecution backOffExecution) {
        this.backOffExecution = backOffExecution;
    }

    public BackOffExecution getBackOffExecution() {
        return this.backOffExecution;
    }

    public void setLocallyTransacted(boolean locallyTransacted) {
        this.locallyTransacted = locallyTransacted;
    }

    public void setApplicationEventPublisher(@Nullable ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void setMissingQueuePublisher(Consumer<String> missingQueuePublisher) {
        this.missingQueuePublisher = missingQueuePublisher;
    }

    public void setConsumeDelay(long consumeDelay) {
        this.consumeDelay = consumeDelay;
    }

    public void setMessageAckListener(MessageAckListener messageAckListener) {
        Assert.notNull((Object)messageAckListener, (String)"'messageAckListener' cannot be null");
        this.messageAckListener = messageAckListener;
    }

    public void clearDeliveryTags() {
        this.deliveryTags.clear();
    }

    public void setGlobalQos(boolean globalQos) {
        this.globalQos = globalQos;
    }

    public boolean isNormalCancel() {
        return this.normalCancel;
    }

    int getQueueCount() {
        return this.queues.length;
    }

    protected void basicCancel() {
        this.basicCancel(true);
    }

    protected void basicCancel(boolean expected) {
        this.normalCancel = expected;
        this.getConsumerTags().forEach(consumerTag -> {
            if (this.channel.isOpen()) {
                RabbitUtils.cancel(this.channel, consumerTag);
            }
        });
        this.cancelled.set(true);
        this.abortStarted = System.currentTimeMillis();
    }

    protected boolean hasDelivery() {
        return !this.queue.isEmpty();
    }

    protected boolean cancelled() {
        return this.cancelled.get() || this.abortStarted > 0L && this.abortStarted + this.shutdownTimeout > System.currentTimeMillis() || !this.activeObjectCounter.isActive();
    }

    private void checkShutdown() {
        ShutdownSignalException shutdownToUse = this.shutdown;
        if (shutdownToUse != null) {
            throw (ShutdownSignalException)Utility.fixStackTrace((Throwable)shutdownToUse);
        }
    }

    private @Nullable Message handle(@Nullable Delivery delivery) {
        ShutdownSignalException shutdownToUse = this.shutdown;
        if (delivery == null && shutdownToUse != null) {
            throw shutdownToUse;
        }
        if (delivery == null) {
            return null;
        }
        byte[] body = delivery.getBody();
        Envelope envelope = delivery.getEnvelope();
        MessageProperties messageProperties = this.messagePropertiesConverter.toMessageProperties(delivery.getProperties(), envelope, "UTF-8");
        messageProperties.setConsumerTag(delivery.getConsumerTag());
        messageProperties.setConsumerQueue(delivery.getQueue());
        Message message = new Message(body, messageProperties);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Received message: " + String.valueOf(message)));
        }
        this.deliveryTags.add(messageProperties.getDeliveryTag());
        if (this.transactional && !this.locallyTransacted) {
            ConnectionFactoryUtils.registerDeliveryTag(this.connectionFactory, this.channel, delivery.getEnvelope().getDeliveryTag());
        }
        return message;
    }

    public @Nullable Message nextMessage() throws InterruptedException, ShutdownSignalException {
        return this.nextMessage(-1L);
    }

    public @Nullable Message nextMessage(long timeout) throws InterruptedException, ShutdownSignalException {
        Message message;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Retrieving delivery for " + String.valueOf(this)));
        }
        this.checkShutdown();
        if (!this.missingQueues.isEmpty()) {
            this.checkMissingQueues();
        }
        if ((message = this.handle(timeout < 0L ? this.queue.take() : this.queue.poll(timeout, TimeUnit.MILLISECONDS))) == null && this.cancelled.get()) {
            this.activeObjectCounter.release(this);
            throw new ConsumerCancelledException();
        }
        return message;
    }

    /*
     * Exception decompiling
     */
    private void checkMissingQueues() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void start() throws AmqpException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Starting consumer " + String.valueOf(this)));
        }
        this.thread = Thread.currentThread();
        try {
            this.resourceHolder = ConnectionFactoryUtils.getTransactionalResourceHolder(this.connectionFactory, this.transactional);
            this.channel = this.resourceHolder.getChannel();
            ClosingRecoveryListener.addRecoveryListenerIfNecessary(this.channel);
        }
        catch (AmqpAuthenticationException e) {
            throw new FatalListenerStartupException("Authentication failure", e);
        }
        this.deliveryTags.clear();
        this.activeObjectCounter.add(this);
        this.passiveDeclarations();
        this.setQosAndCreateConsumers();
    }

    private void passiveDeclarations() {
        int passiveDeclareRetries = this.declarationRetries;
        this.declaring = true;
        while (!this.cancelled()) {
            try {
                this.attemptPassiveDeclarations();
                if (passiveDeclareRetries < this.declarationRetries && logger.isInfoEnabled()) {
                    logger.info((Object)"Queue declaration succeeded after retrying");
                }
                passiveDeclareRetries = 0;
            }
            catch (DeclarationException e) {
                this.handleDeclarationException(passiveDeclareRetries, e);
            }
            if (passiveDeclareRetries-- > 0 && !this.cancelled()) continue;
        }
        this.declaring = false;
    }

    private void setQosAndCreateConsumers() {
        if (this.consumeDelay > 0L) {
            try {
                Thread.sleep(this.consumeDelay);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (!this.acknowledgeMode.isAutoAck() && !this.cancelled()) {
            try {
                this.channel.basicQos(this.prefetchCount, this.globalQos);
            }
            catch (IOException e) {
                this.activeObjectCounter.release(this);
                throw new AmqpIOException(e);
            }
        }
        try {
            if (!this.cancelled()) {
                for (String queueName : this.queues) {
                    if (this.missingQueues.contains(queueName)) continue;
                    this.consumeFromQueue(queueName);
                }
            }
        }
        catch (IOException e) {
            throw RabbitExceptionTranslator.convertRabbitAccessException(e);
        }
    }

    private void handleDeclarationException(int passiveDeclareRetries, DeclarationException e) {
        if (passiveDeclareRetries > 0 && this.channel.isOpen()) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Queue declaration failed; retries left=" + passiveDeclareRetries), (Throwable)((Object)e));
            }
            try {
                Thread.sleep(this.failedDeclarationRetryInterval);
            }
            catch (InterruptedException e1) {
                this.declaring = false;
                Thread.currentThread().interrupt();
                this.activeObjectCounter.release(this);
                throw RabbitExceptionTranslator.convertRabbitAccessException(e1);
            }
        } else if (e.getFailedQueues().size() < this.queues.length) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Not all queues are available; only listening on those that are - configured: " + String.valueOf(Arrays.asList(this.queues)) + "; not available: " + String.valueOf(e.getFailedQueues())));
            }
            this.missingQueues.addAll(e.getFailedQueues());
            this.lastRetryDeclaration = System.currentTimeMillis();
        } else {
            this.declaring = false;
            this.activeObjectCounter.release(this);
            throw new QueuesNotAvailableException("Cannot prepare queue for listener. Either the queue doesn't exist or the broker will not allow us to use it.", (Throwable)((Object)e));
        }
    }

    private void consumeFromQueue(String queue) throws IOException {
        InternalConsumer consumer = new InternalConsumer(this.channel, queue);
        String consumerTag = this.channel.basicConsume(queue, this.acknowledgeMode.isAutoAck(), this.tagStrategy != null ? this.tagStrategy.createConsumerTag(queue) : "", this.noLocal, this.exclusive, this.consumerArgs, (com.rabbitmq.client.Consumer)consumer);
        if (consumerTag != null) {
            this.consumers.put(queue, consumer);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Started on queue '" + queue + "' with tag " + consumerTag + ": " + String.valueOf(this)));
            }
        } else {
            logger.error((Object)("Null consumer tag received for queue " + queue));
        }
    }

    private void attemptPassiveDeclarations() {
        DeclarationException failures = null;
        for (String queueName : this.queues) {
            try {
                try {
                    this.channel.queueDeclarePassive(queueName);
                }
                catch (IllegalArgumentException e) {
                    try {
                        Channel channel = this.channel;
                        if (channel instanceof ChannelProxy) {
                            ChannelProxy proxy = (ChannelProxy)channel;
                            proxy.getTargetChannel().close();
                        }
                    }
                    catch (TimeoutException timeoutException) {
                        // empty catch block
                    }
                    throw new FatalListenerStartupException("Illegal Argument on Queue Declaration", e);
                }
            }
            catch (IOException e) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)("Failed to declare queue: " + queueName));
                }
                this.missingQueuePublisher.accept(queueName);
                if (!this.channel.isOpen()) {
                    throw new AmqpIOException(e);
                }
                if (failures == null) {
                    failures = new DeclarationException(e);
                }
                failures.addFailedQueue(queueName);
            }
        }
        if (failures != null) {
            throw failures;
        }
    }

    public void stop() {
        this.lifecycleLock.lock();
        try {
            block9: {
                if (this.abortStarted == 0L) {
                    this.abortStarted = System.currentTimeMillis();
                }
                if (!this.cancelled()) {
                    this.basicCancel(true);
                }
                try {
                    if (this.transactional) {
                        this.channel.basicRecover(true);
                    }
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block9;
                    logger.debug((Object)("Error closing consumer " + String.valueOf(this)), (Throwable)e);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Closing Rabbit Channel: " + String.valueOf(this.channel)));
            }
            this.forceCloseAndClearQueue();
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public void forceCloseAndClearQueue() {
        RabbitUtils.setPhysicalCloseRequired(this.channel, true);
        ConnectionFactoryUtils.releaseResources(this.resourceHolder);
        this.deliveryTags.clear();
        this.consumers.clear();
        this.queue.clear();
    }

    public void rollbackOnExceptionIfNecessary(Throwable ex) {
        this.rollbackOnExceptionIfNecessary(ex, -1L);
    }

    public void rollbackOnExceptionIfNecessary(Throwable ex, long tag) {
        boolean ackRequired = !this.acknowledgeMode.isAutoAck() && (!this.acknowledgeMode.isManual() || ContainerUtils.isRejectManual(ex));
        try {
            if (this.transactional) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Initiating transaction rollback on application exception: " + String.valueOf(ex)));
                }
                RabbitUtils.rollbackIfNecessary(this.channel);
            }
            if (ackRequired) {
                if (tag < 0L) {
                    OptionalLong deliveryTag = this.deliveryTags.stream().mapToLong(l -> l).max();
                    if (deliveryTag.isPresent()) {
                        this.channel.basicNack(deliveryTag.getAsLong(), true, ContainerUtils.shouldRequeue(this.defaultRequeueRejected, ex, logger));
                    }
                    if (this.transactional) {
                        RabbitUtils.commitIfNecessary(this.channel);
                    }
                } else {
                    this.channel.basicNack(tag, false, ContainerUtils.shouldRequeue(this.defaultRequeueRejected, ex, logger));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Application exception overridden by rollback exception", ex);
            throw RabbitExceptionTranslator.convertRabbitAccessException(e);
        }
        finally {
            if (tag < 0L) {
                this.deliveryTags.clear();
            } else {
                this.deliveryTags.remove(tag);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean commitIfNecessary(boolean localTx, boolean forceAck) {
        if (this.deliveryTags.isEmpty()) {
            return false;
        }
        boolean isLocallyTransacted = localTx || this.transactional && TransactionSynchronizationManager.getResource((Object)this.connectionFactory) == null;
        try {
            boolean ackRequired;
            boolean bl = ackRequired = forceAck || !this.acknowledgeMode.isAutoAck() && !this.acknowledgeMode.isManual();
            if (ackRequired && (!this.transactional || isLocallyTransacted)) {
                OptionalLong deliveryTag = this.deliveryTags.stream().mapToLong(l -> l).max();
                deliveryTag.ifPresent(tag -> {
                    try {
                        this.channel.basicAck(tag, true);
                        this.notifyMessageAckListener(true, tag, null);
                    }
                    catch (Exception e) {
                        logger.error((Object)"Error acking.", (Throwable)e);
                        this.notifyMessageAckListener(false, tag, e);
                    }
                });
            }
            if (isLocallyTransacted) {
                RabbitUtils.commitIfNecessary(this.channel);
            }
        }
        finally {
            this.deliveryTags.clear();
        }
        return true;
    }

    private void notifyMessageAckListener(boolean success, long deliveryTag, @Nullable Throwable cause) {
        if (this.messageAckListener != null) {
            try {
                this.messageAckListener.onComplete(success, deliveryTag, cause);
            }
            catch (Exception e) {
                logger.error((Object)"An exception occurred in MessageAckListener.", (Throwable)e);
            }
        }
    }

    public String toString() {
        return "Consumer@" + ObjectUtils.getIdentityHexString((Object)this) + ": tags=[" + String.valueOf(this.getConsumerTags()) + "], channel=" + String.valueOf(this.channel) + ", acknowledgeMode=" + String.valueOf(this.acknowledgeMode) + " local queue size=" + this.queue.size();
    }

    private static final class DeclarationException
    extends AmqpException {
        private final List<String> failedQueues = new ArrayList<String>();

        DeclarationException() {
            super("Failed to declare queue(s):");
        }

        private DeclarationException(Throwable t) {
            super("Failed to declare queue(s):", t);
        }

        private void addFailedQueue(String queue) {
            this.failedQueues.add(queue);
        }

        private List<String> getFailedQueues() {
            return this.failedQueues;
        }

        public String getMessage() {
            return super.getMessage() + String.valueOf(this.failedQueues);
        }
    }

    private final class InternalConsumer
    extends DefaultConsumer {
        private final String queueName;
        private boolean canceled;

        InternalConsumer(Channel channel, String queue) {
            super(channel);
            this.queueName = queue;
        }

        public void handleConsumeOk(String consumerTag) {
            super.handleConsumeOk(consumerTag);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ConsumeOK: " + String.valueOf(BlockingQueueConsumer.this)));
            }
            if (BlockingQueueConsumer.this.applicationEventPublisher != null) {
                BlockingQueueConsumer.this.applicationEventPublisher.publishEvent((ApplicationEvent)new ConsumeOkEvent((Object)this, this.queueName, consumerTag));
            }
        }

        public void handleShutdownSignal(String consumerTag, ShutdownSignalException sig) {
            if (logger.isDebugEnabled()) {
                if (RabbitUtils.isNormalShutdown(sig)) {
                    logger.debug((Object)("Received shutdown signal for consumer tag=" + consumerTag + ": " + sig.getMessage()));
                } else {
                    logger.debug((Object)("Received shutdown signal for consumer tag=" + consumerTag), (Throwable)sig);
                }
            }
            BlockingQueueConsumer.this.shutdown = sig;
            BlockingQueueConsumer.this.deliveryTags.clear();
            BlockingQueueConsumer.this.activeObjectCounter.release(BlockingQueueConsumer.this);
        }

        public void handleCancel(String consumerTag) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Cancel received for " + consumerTag + " (" + this.queueName + "); " + String.valueOf(BlockingQueueConsumer.this)));
            }
            BlockingQueueConsumer.this.consumers.remove(this.queueName);
            if (!BlockingQueueConsumer.this.consumers.isEmpty()) {
                BlockingQueueConsumer.this.basicCancel(false);
            } else {
                BlockingQueueConsumer.this.cancelled.set(true);
            }
        }

        public void handleCancelOk(String consumerTag) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Received cancelOk for tag " + consumerTag + " (" + this.queueName + "); " + String.valueOf(BlockingQueueConsumer.this)));
            }
            this.canceled = true;
        }

        public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Storing delivery for consumerTag: '" + consumerTag + "' with deliveryTag: '" + envelope.getDeliveryTag() + "' in " + String.valueOf(BlockingQueueConsumer.this)));
            }
            try {
                if (BlockingQueueConsumer.this.abortStarted > 0L) {
                    if (!BlockingQueueConsumer.this.queue.offer(new Delivery(consumerTag, envelope, properties, body, this.queueName), BlockingQueueConsumer.this.shutdownTimeout, TimeUnit.MILLISECONDS)) {
                        Channel channelToClose = super.getChannel();
                        RabbitUtils.setPhysicalCloseRequired(channelToClose, true);
                        BlockingQueueConsumer.this.queue.clear();
                        if (!this.canceled) {
                            RabbitUtils.cancel(channelToClose, consumerTag);
                        }
                        try {
                            channelToClose.close();
                        }
                        catch (TimeoutException timeoutException) {}
                    }
                } else {
                    BlockingQueueConsumer.this.queue.put(new Delivery(consumerTag, envelope, properties, body, this.queueName));
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                logger.warn((Object)"Unexpected exception during delivery", (Throwable)e);
            }
        }

        public String toString() {
            return "InternalConsumer{queue='" + this.queueName + "', consumerTag='" + this.getConsumerTag() + "'}";
        }
    }
}

