/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.support;

import org.jspecify.annotations.Nullable;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Expression;
import org.springframework.expression.TypedValue;
import org.springframework.expression.common.ExpressionUtils;

public class ValueExpression<V>
implements Expression {
    private final @Nullable V value;
    private final @Nullable Class<V> aClass;
    private final TypedValue typedResultValue;
    private final @Nullable TypeDescriptor typeDescriptor;

    public ValueExpression(@Nullable V value) {
        this.value = value;
        this.aClass = this.value != null ? this.value.getClass() : null;
        this.typedResultValue = new TypedValue(this.value);
        this.typeDescriptor = this.typedResultValue.getTypeDescriptor();
    }

    public @Nullable V getValue() throws EvaluationException {
        return this.value;
    }

    public @Nullable V getValue(@Nullable Object rootObject) throws EvaluationException {
        return this.value;
    }

    public @Nullable V getValue(EvaluationContext context) throws EvaluationException {
        return this.value;
    }

    public @Nullable V getValue(EvaluationContext context, @Nullable Object rootObject) throws EvaluationException {
        return this.value;
    }

    public <T> @Nullable T getValue(@Nullable Object rootObject, @Nullable Class<T> desiredResultType) throws EvaluationException {
        return this.getValue(desiredResultType);
    }

    public <T> @Nullable T getValue(@Nullable Class<T> desiredResultType) throws EvaluationException {
        return (T)ExpressionUtils.convertTypedValue(null, (TypedValue)this.typedResultValue, desiredResultType);
    }

    public <T> @Nullable T getValue(EvaluationContext context, @Nullable Object rootObject, @Nullable Class<T> desiredResultType) throws EvaluationException {
        return this.getValue(context, desiredResultType);
    }

    public <T> @Nullable T getValue(EvaluationContext context, @Nullable Class<T> desiredResultType) throws EvaluationException {
        return (T)ExpressionUtils.convertTypedValue((EvaluationContext)context, (TypedValue)this.typedResultValue, desiredResultType);
    }

    public @Nullable Class<V> getValueType() throws EvaluationException {
        return this.aClass;
    }

    public @Nullable Class<V> getValueType(@Nullable Object rootObject) throws EvaluationException {
        return this.aClass;
    }

    public @Nullable Class<V> getValueType(EvaluationContext context) throws EvaluationException {
        return this.aClass;
    }

    public @Nullable Class<V> getValueType(EvaluationContext context, @Nullable Object rootObject) throws EvaluationException {
        return this.aClass;
    }

    public @Nullable TypeDescriptor getValueTypeDescriptor() throws EvaluationException {
        return this.typeDescriptor;
    }

    public @Nullable TypeDescriptor getValueTypeDescriptor(@Nullable Object rootObject) throws EvaluationException {
        return this.typeDescriptor;
    }

    public @Nullable TypeDescriptor getValueTypeDescriptor(EvaluationContext context) throws EvaluationException {
        return this.typeDescriptor;
    }

    public @Nullable TypeDescriptor getValueTypeDescriptor(EvaluationContext context, @Nullable Object rootObject) throws EvaluationException {
        return this.typeDescriptor;
    }

    public boolean isWritable(EvaluationContext context) throws EvaluationException {
        return false;
    }

    public boolean isWritable(EvaluationContext context, @Nullable Object rootObject) throws EvaluationException {
        return false;
    }

    public boolean isWritable(@Nullable Object rootObject) throws EvaluationException {
        return false;
    }

    public void setValue(EvaluationContext context, @Nullable Object value) throws EvaluationException {
        this.setValue(context, null, value);
    }

    public void setValue(@Nullable Object rootObject, @Nullable Object value) throws EvaluationException {
        this.setValue(null, rootObject, value);
    }

    public void setValue(@Nullable EvaluationContext context, @Nullable Object rootObject, @Nullable Object value) throws EvaluationException {
        throw new EvaluationException(this.getExpressionString(), "Cannot call setValue() on a ValueExpression");
    }

    public String getExpressionString() {
        return this.value != null ? this.value.toString() : "null";
    }
}

