/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.config;

import java.time.Duration;
import java.util.function.Consumer;
import org.aopalliance.intercept.MethodInterceptor;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.rabbit.config.AbstractRetryOperationsInterceptorFactoryBean;
import org.springframework.amqp.rabbit.config.StatefulRetryOperationsInterceptor;
import org.springframework.amqp.rabbit.config.StatefulRetryOperationsInterceptorFactoryBean;
import org.springframework.amqp.rabbit.config.StatelessRetryOperationsInterceptor;
import org.springframework.amqp.rabbit.config.StatelessRetryOperationsInterceptorFactoryBean;
import org.springframework.amqp.rabbit.retry.MessageKeyGenerator;
import org.springframework.amqp.rabbit.retry.MessageRecoverer;
import org.springframework.amqp.rabbit.retry.NewMessageIdentifier;
import org.springframework.core.retry.RetryPolicy;
import org.springframework.util.Assert;

public abstract class RetryInterceptorBuilder<B extends RetryInterceptorBuilder<B, T>, T extends MethodInterceptor> {
    private final RetryPolicy.Builder retryPolicyBuilder = RetryPolicy.builder();
    private @Nullable RetryPolicy retryPolicy;
    private @Nullable MessageRecoverer messageRecoverer;
    private boolean templateAltered;
    private boolean retryPolicySet;

    public static StatefulRetryInterceptorBuilder stateful() {
        return new StatefulRetryInterceptorBuilder();
    }

    public static StatelessRetryInterceptorBuilder stateless() {
        return new StatelessRetryInterceptorBuilder();
    }

    protected final B _this() {
        return (B)this;
    }

    public B retryPolicy(RetryPolicy policy) {
        Assert.isTrue((!this.templateAltered ? 1 : 0) != 0, (String)"cannot set the retry policy if max attempts or back off policy or options changed");
        this.retryPolicy = policy;
        this.retryPolicySet = true;
        this.templateAltered = true;
        return this._this();
    }

    public B configureRetryPolicy(Consumer<RetryPolicy.Builder> retryPolicy) {
        Assert.isTrue((!this.retryPolicySet ? 1 : 0) != 0, (String)"cannot alter the retry policy when a custom retryPolicy has been set");
        retryPolicy.accept(this.retryPolicyBuilder);
        return this._this();
    }

    public B maxAttempts(int maxAttempts) {
        return this.configureRetryPolicy(retryPolicy -> retryPolicy.maxAttempts((long)maxAttempts));
    }

    public B backOffOptions(long initialInterval, double multiplier, long maxInterval) {
        return this.configureRetryPolicy(retryPolicy -> retryPolicy.delay(Duration.ofMillis(initialInterval)).multiplier(multiplier).maxDelay(Duration.ofMillis(maxInterval)));
    }

    public B recoverer(MessageRecoverer recoverer) {
        this.messageRecoverer = recoverer;
        return this._this();
    }

    protected void applyCommonSettings(AbstractRetryOperationsInterceptorFactoryBean factoryBean) {
        if (this.messageRecoverer != null) {
            factoryBean.setMessageRecoverer(this.messageRecoverer);
        }
        RetryPolicy retryPolicyToUse = this.retryPolicy != null ? this.retryPolicy : this.retryPolicyBuilder.build();
        factoryBean.setRetryPolicy(retryPolicyToUse);
    }

    public abstract T build();

    public static final class StatefulRetryInterceptorBuilder
    extends RetryInterceptorBuilder<StatefulRetryInterceptorBuilder, StatefulRetryOperationsInterceptor> {
        private final StatefulRetryOperationsInterceptorFactoryBean factoryBean = new StatefulRetryOperationsInterceptorFactoryBean();
        private @Nullable MessageKeyGenerator messageKeyGenerator;
        private @Nullable NewMessageIdentifier newMessageIdentifier;

        StatefulRetryInterceptorBuilder() {
        }

        public StatefulRetryInterceptorBuilder messageKeyGenerator(MessageKeyGenerator messageKeyGenerator) {
            this.messageKeyGenerator = messageKeyGenerator;
            return this;
        }

        public StatefulRetryInterceptorBuilder newMessageIdentifier(NewMessageIdentifier newMessageIdentifier) {
            this.newMessageIdentifier = newMessageIdentifier;
            return this;
        }

        @Override
        public StatefulRetryOperationsInterceptor build() {
            this.applyCommonSettings(this.factoryBean);
            if (this.messageKeyGenerator != null) {
                this.factoryBean.setMessageKeyGenerator(this.messageKeyGenerator);
            }
            if (this.newMessageIdentifier != null) {
                this.factoryBean.setNewMessageIdentifier(this.newMessageIdentifier);
            }
            return this.factoryBean.getObject();
        }
    }

    public static final class StatelessRetryInterceptorBuilder
    extends RetryInterceptorBuilder<StatelessRetryInterceptorBuilder, StatelessRetryOperationsInterceptor> {
        private final StatelessRetryOperationsInterceptorFactoryBean factoryBean = new StatelessRetryOperationsInterceptorFactoryBean();

        StatelessRetryInterceptorBuilder() {
        }

        @Override
        public StatelessRetryOperationsInterceptor build() {
            this.applyCommonSettings(this.factoryBean);
            return this.factoryBean.getObject();
        }
    }
}

