/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.config;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.ImmediateAcknowledgeAmqpException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.retry.MessageBatchRecoverer;
import org.springframework.amqp.rabbit.retry.MessageKeyGenerator;
import org.springframework.amqp.rabbit.retry.MessageRecoverer;
import org.springframework.amqp.rabbit.retry.NewMessageIdentifier;
import org.springframework.core.retry.RetryPolicy;
import org.springframework.util.backoff.BackOffExecution;

public final class StatefulRetryOperationsInterceptor
implements MethodInterceptor {
    private static final Log LOGGER = LogFactory.getLog(StatefulRetryOperationsInterceptor.class);
    private final MessageKeyGenerator messageKeyGenerator;
    private final NewMessageIdentifier newMessageIdentifier;
    private final RetryPolicy retryPolicy;
    private final @Nullable MessageRecoverer messageRecoverer;
    private final Map<Object, RetryState> cache = new ConcurrentHashMap<Object, RetryState>();

    StatefulRetryOperationsInterceptor(MessageKeyGenerator messageKeyGenerator, NewMessageIdentifier newMessageIdentifier, @Nullable RetryPolicy retryPolicy, @Nullable MessageRecoverer messageRecoverer) {
        this.messageKeyGenerator = messageKeyGenerator;
        this.newMessageIdentifier = newMessageIdentifier;
        this.retryPolicy = retryPolicy != null ? retryPolicy : RetryPolicy.builder().build();
        this.messageRecoverer = messageRecoverer;
    }

    public @Nullable Object invoke(MethodInvocation invocation) throws Throwable {
        @Nullable Object[] args = invocation.getArguments();
        Message message = StatefulRetryOperationsInterceptor.argToMessage(args);
        Object key = this.messageKeyGenerator.getKey(message);
        if (key == null) {
            return invocation.proceed();
        }
        RetryState retryState = this.cache.get(key);
        if (retryState == null || this.newMessageIdentifier.isNew(message)) {
            try {
                return invocation.proceed();
            }
            catch (Throwable ex) {
                this.cache.put(key, new RetryState(this.retryPolicy.getBackOff().start(), ex));
                throw ex;
            }
        }
        long time = retryState.backOffExecution().nextBackOff();
        if (time == -1L || !this.retryPolicy.shouldRetry(retryState.lastException())) {
            this.cache.remove(key);
            this.recover(args[1], retryState.lastException());
            throw new ImmediateAcknowledgeAmqpException("Recovered message forces ack (if ack mode requires it): " + String.valueOf(args[1]), retryState.lastException());
        }
        Thread.sleep(time);
        try {
            Object result = invocation.proceed();
            this.cache.remove(key);
            return result;
        }
        catch (Throwable ex) {
            this.cache.put(key, new RetryState(retryState.backOffExecution(), ex));
            throw ex;
        }
    }

    private void recover(@Nullable Object arg, Throwable cause) {
        MessageRecoverer messageRecoverer;
        if (this.messageRecoverer == null) {
            LOGGER.warn((Object)("Message(s) dropped on recovery: " + String.valueOf(arg)), cause);
        } else if (arg instanceof Message) {
            Message msg = (Message)arg;
            this.messageRecoverer.recover(msg, cause);
        } else if (arg instanceof List && (messageRecoverer = this.messageRecoverer) instanceof MessageBatchRecoverer) {
            MessageBatchRecoverer recoverer = (MessageBatchRecoverer)messageRecoverer;
            recoverer.recover((List)arg, cause);
        }
    }

    private static Message argToMessage(@Nullable Object[] args) {
        Object arg;
        Object object = arg = args.length > 1 ? args[1] : null;
        if (arg instanceof Message) {
            Message msg = (Message)arg;
            return msg;
        }
        if (arg instanceof List) {
            List list = (List)arg;
            return (Message)list.get(0);
        }
        throw new IllegalArgumentException("Expected 2nd arguments to be a message, got " + Arrays.toString(args));
    }

    record RetryState(BackOffExecution backOffExecution, Throwable lastException) {
    }
}

