/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener.adapter;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.springframework.amqp.rabbit.listener.adapter.DelegatingInvocableHandler;
import org.springframework.amqp.rabbit.listener.adapter.InvocationResult;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;

public class HandlerAdapter {
    private final InvocableHandlerMethod invokerHandlerMethod;
    private final DelegatingInvocableHandler delegatingHandler;

    public HandlerAdapter(InvocableHandlerMethod invokerHandlerMethod) {
        this.invokerHandlerMethod = invokerHandlerMethod;
        this.delegatingHandler = null;
    }

    public HandlerAdapter(DelegatingInvocableHandler delegatingHandler) {
        this.invokerHandlerMethod = null;
        this.delegatingHandler = delegatingHandler;
    }

    public InvocationResult invoke(@Nullable Message<?> message, Object ... providedArgs) throws Exception {
        if (this.invokerHandlerMethod != null) {
            return new InvocationResult(this.invokerHandlerMethod.invoke(message, providedArgs), null, this.invokerHandlerMethod.getMethod().getGenericReturnType(), this.invokerHandlerMethod.getBean(), this.invokerHandlerMethod.getMethod());
        }
        if (this.delegatingHandler.hasDefaultHandler()) {
            Object[] args = new Object[providedArgs.length + 1];
            args[0] = message.getPayload();
            System.arraycopy(providedArgs, 0, args, 1, providedArgs.length);
            return this.delegatingHandler.invoke(message, args);
        }
        return this.delegatingHandler.invoke(message, providedArgs);
    }

    public String getMethodAsString(Object payload) {
        if (this.invokerHandlerMethod != null) {
            return this.invokerHandlerMethod.getMethod().toGenericString();
        }
        return this.delegatingHandler.getMethodNameFor(payload);
    }

    public Method getMethodFor(Object payload) {
        if (this.invokerHandlerMethod != null) {
            return this.invokerHandlerMethod.getMethod();
        }
        return this.delegatingHandler.getMethodFor(payload);
    }

    public Type getReturnTypeFor(Object payload) {
        if (this.invokerHandlerMethod != null) {
            return this.invokerHandlerMethod.getMethod().getReturnType();
        }
        return this.delegatingHandler.getMethodFor(payload).getReturnType();
    }

    public Object getBean() {
        if (this.invokerHandlerMethod != null) {
            return this.invokerHandlerMethod.getBean();
        }
        return this.delegatingHandler.getBean();
    }

    @Nullable
    public InvocationResult getInvocationResultFor(Object result, Object inboundPayload) {
        if (this.invokerHandlerMethod != null) {
            return new InvocationResult(result, null, this.invokerHandlerMethod.getMethod().getGenericReturnType(), this.invokerHandlerMethod.getBean(), this.invokerHandlerMethod.getMethod());
        }
        return this.delegatingHandler.getInvocationResultFor(result, inboundPayload);
    }
}

