/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.support;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.LongString;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.support.MessagePropertiesConverter;
import org.springframework.amqp.rabbit.support.RabbitExceptionTranslator;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DefaultMessagePropertiesConverter
implements MessagePropertiesConverter {
    private static final int DEFAULT_LONG_STRING_LIMIT = 1024;
    private final int longStringLimit;
    private final boolean convertLongLongStrings;

    public DefaultMessagePropertiesConverter() {
        this(1024, false);
    }

    public DefaultMessagePropertiesConverter(int longStringLimit) {
        this(longStringLimit, false);
    }

    public DefaultMessagePropertiesConverter(int longStringLimit, boolean convertLongLongStrings) {
        this.longStringLimit = longStringLimit;
        this.convertLongLongStrings = convertLongLongStrings;
    }

    @Override
    public MessageProperties toMessageProperties(AMQP.BasicProperties source, Envelope envelope, String charset) {
        String replyTo;
        MessageProperties target = new MessageProperties();
        Map headers = source.getHeaders();
        if (!CollectionUtils.isEmpty((Map)headers)) {
            for (Map.Entry entry : headers.entrySet()) {
                String key = (String)entry.getKey();
                if ("x-delay".equals(key)) {
                    Object value = entry.getValue();
                    if (!(value instanceof Integer)) continue;
                    target.setReceivedDelay((Integer)value);
                    continue;
                }
                target.setHeader(key, this.convertLongStringIfNecessary(entry.getValue(), charset));
            }
        }
        target.setTimestamp(source.getTimestamp());
        target.setMessageId(source.getMessageId());
        target.setReceivedUserId(source.getUserId());
        target.setAppId(source.getAppId());
        target.setClusterId(source.getClusterId());
        target.setType(source.getType());
        Integer deliveryMode = source.getDeliveryMode();
        if (deliveryMode != null) {
            target.setReceivedDeliveryMode(MessageDeliveryMode.fromInt((int)deliveryMode));
        }
        target.setDeliveryMode(null);
        target.setExpiration(source.getExpiration());
        target.setPriority(source.getPriority());
        target.setContentType(source.getContentType());
        target.setContentEncoding(source.getContentEncoding());
        String correlationId = source.getCorrelationId();
        if (StringUtils.hasText((String)correlationId)) {
            target.setCorrelationId(source.getCorrelationId());
        }
        if ((replyTo = source.getReplyTo()) != null) {
            target.setReplyTo(replyTo);
        }
        if (envelope != null) {
            target.setReceivedExchange(envelope.getExchange());
            target.setReceivedRoutingKey(envelope.getRoutingKey());
            target.setRedelivered(Boolean.valueOf(envelope.isRedeliver()));
            target.setDeliveryTag(envelope.getDeliveryTag());
        }
        return target;
    }

    @Override
    public AMQP.BasicProperties fromMessageProperties(MessageProperties source, String charset) {
        String replyTo;
        AMQP.BasicProperties.Builder target = new AMQP.BasicProperties.Builder();
        target.headers(this.convertHeadersIfNecessary(source.getHeaders())).timestamp(source.getTimestamp()).messageId(source.getMessageId()).userId(source.getUserId()).appId(source.getAppId()).clusterId(source.getClusterId()).type(source.getType());
        MessageDeliveryMode deliveryMode = source.getDeliveryMode();
        if (deliveryMode != null) {
            target.deliveryMode(Integer.valueOf(MessageDeliveryMode.toInt((MessageDeliveryMode)deliveryMode)));
        }
        target.expiration(source.getExpiration()).priority(source.getPriority()).contentType(source.getContentType()).contentEncoding(source.getContentEncoding());
        String correlationId = source.getCorrelationId();
        if (StringUtils.hasText((String)correlationId)) {
            target.correlationId(correlationId);
        }
        if ((replyTo = source.getReplyTo()) != null) {
            target.replyTo(replyTo);
        }
        return target.build();
    }

    private Map<String, Object> convertHeadersIfNecessary(Map<String, Object> headers) {
        if (CollectionUtils.isEmpty(headers)) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> writableHeaders = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            writableHeaders.put(entry.getKey(), this.convertHeaderValueIfNecessary(entry.getValue()));
        }
        return writableHeaders;
    }

    @Nullable
    private Object convertHeaderValueIfNecessary(@Nullable Object valueArg) {
        boolean valid;
        Object value = valueArg;
        boolean bl = valid = value instanceof String || value instanceof byte[] || value instanceof Boolean || value instanceof Class || value instanceof LongString || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof BigDecimal || value instanceof Short || value instanceof Byte || value instanceof Date || value instanceof List || value instanceof Map || value instanceof Object[];
        if (!valid && value != null) {
            value = value.toString();
        } else if (value instanceof Object[]) {
            Object[] array = value;
            Object[] writableArray = new Object[array.length];
            for (int i = 0; i < writableArray.length; ++i) {
                writableArray[i] = this.convertHeaderValueIfNecessary(array[i]);
            }
            value = writableArray;
        } else if (value instanceof List) {
            ArrayList<Object> writableList = new ArrayList<Object>(((List)value).size());
            for (Object listValue : (List)value) {
                writableList.add(this.convertHeaderValueIfNecessary(listValue));
            }
            value = writableList;
        } else if (value instanceof Map) {
            Map originalMap = (Map)value;
            HashMap writableMap = new HashMap(originalMap.size());
            for (Map.Entry entry : originalMap.entrySet()) {
                writableMap.put(entry.getKey(), this.convertHeaderValueIfNecessary(entry.getValue()));
            }
            value = writableMap;
        } else if (value instanceof Class) {
            value = ((Class)value).getName();
        }
        return value;
    }

    private Object convertLongString(LongString longString, String charset) {
        try {
            if (longString.length() <= (long)this.longStringLimit) {
                return new String(longString.getBytes(), charset);
            }
            return this.convertLongLongStrings ? longString.getStream() : longString;
        }
        catch (Exception e) {
            throw RabbitExceptionTranslator.convertRabbitAccessException(e);
        }
    }

    private Object convertLongStringIfNecessary(Object valueArg, String charset) {
        Cloneable value = valueArg;
        if (value instanceof LongString) {
            value = this.convertLongString((LongString)value, charset);
        } else if (value instanceof List) {
            ArrayList<Object> convertedList = new ArrayList<Object>(((List)((Object)value)).size());
            for (Object listValue : (List)((Object)value)) {
                convertedList.add(this.convertLongStringIfNecessary(listValue, charset));
            }
            value = convertedList;
        } else if (value instanceof Map) {
            Map originalMap = (Map)((Object)value);
            HashMap convertedMap = new HashMap();
            for (Map.Entry entry : originalMap.entrySet()) {
                convertedMap.put(entry.getKey(), this.convertLongStringIfNecessary(entry.getValue(), charset));
            }
            value = convertedMap;
        }
        return value;
    }
}

