/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener;

import org.apache.commons.logging.Log;
import org.springframework.amqp.AmqpRejectAndDontRequeueException;
import org.springframework.amqp.ImmediateRequeueAmqpException;
import org.springframework.amqp.rabbit.listener.MessageRejectedWhileStoppingException;

public final class ContainerUtils {
    private ContainerUtils() {
    }

    public static boolean shouldRequeue(boolean defaultRequeueRejected, Throwable throwable, Log logger) {
        boolean shouldRequeue = defaultRequeueRejected || throwable instanceof MessageRejectedWhileStoppingException || throwable instanceof ImmediateRequeueAmqpException;
        for (Throwable t = throwable; shouldRequeue && t != null; t = t.getCause()) {
            if (!(t instanceof AmqpRejectAndDontRequeueException)) continue;
            shouldRequeue = false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Rejecting messages (requeue=" + shouldRequeue + ")"));
        }
        return shouldRequeue;
    }
}

