/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.core;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitOperations;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class RabbitGatewaySupport
implements InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private RabbitTemplate rabbitTemplate;

    public final void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.rabbitTemplate = this.createRabbitTemplate(connectionFactory);
    }

    protected RabbitTemplate createRabbitTemplate(ConnectionFactory connectionFactory) {
        return new RabbitTemplate(connectionFactory);
    }

    public final ConnectionFactory getConnectionFactory() {
        return this.rabbitTemplate != null ? this.rabbitTemplate.getConnectionFactory() : null;
    }

    @Deprecated
    public final void setRabbitTemplate(RabbitTemplate rabbitTemplate) {
        this.rabbitTemplate = rabbitTemplate;
    }

    public final void setRabbitOperations(RabbitOperations rabbitTemplate) {
        Assert.isInstanceOf(RabbitTemplate.class, (Object)rabbitTemplate);
        this.rabbitTemplate = (RabbitTemplate)rabbitTemplate;
    }

    @Deprecated
    public final RabbitTemplate getRabbitTemplate() {
        return this.rabbitTemplate;
    }

    public final RabbitOperations getRabbitOperations() {
        return this.rabbitTemplate;
    }

    public final void afterPropertiesSet() throws IllegalArgumentException, BeanInitializationException {
        if (this.rabbitTemplate == null) {
            throw new IllegalArgumentException("'connectionFactory' or 'rabbitTemplate' is required");
        }
        try {
            this.initGateway();
        }
        catch (Exception ex) {
            throw new BeanInitializationException("Initialization of Rabbit gateway failed: " + ex.getMessage(), (Throwable)ex);
        }
    }

    protected void initGateway() throws Exception {
    }
}

